// Copyright 2011 naehrwert
// Licensed under the terms of the GNU GPL, version 2
// http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

#ifndef _UTIL_H_
#define _UTIL_H_

#include "types.h"

/*! Align operation. */
#define ALIGN(x, a) (((x) + (a) - 1) & ~((a) - 1))

/*! Bitmaps. */
typedef u32 bitmap_t;
//HACK!
#define BITMAP_SIZE(x) ALIGN((x / (sizeof(u32) * 8))+1, 1)

#define IFB(a) (a / (sizeof(u32) * 8))
#define OFB(a) (a % (sizeof(u32) * 8))

static inline void bmap_set_bit(bitmap_t *bmap, u32 idx)
{
	bmap[IFB(idx)] |= (1 << OFB(idx));
}

static inline void bmap_clear_bit(bitmap_t *bmap, u32 idx)
{
	bmap[IFB(idx)] &= ~(1 << OFB(idx));
}

static inline u32 bmap_test_bit(bitmap_t *bmap, u32 idx)
{
	return (bmap[IFB(idx)] & (1 << OFB(idx)));
}

static u32 bmap_find_free(bitmap_t *bmap, u32 size, u32 cnt)
{
	u32 i, j, to;
	bool ok;
	
	for(i = 0; i < size; i++)
	{
		ok = true;
		to = i + cnt;
		for(j = i; j < to; j++)
			if(bmap_test_bit(bmap, j))
				ok = false;
		if(ok == true)
			return i;
	}
	
	return 0;
}

#endif
