// Copyright 2011 naehrwert
// Licensed under the terms of the GNU GPL, version 2
// http://www.gnu.org/licenses/old-licenses/gpl-2.0.txt

#include "common.h"
#include "spud.h"
#include "subroutine.h"

static void _registers_analyze_subroutine(subroutine_t *sr)
{
	u32 i;

	DBGPRINTF("registers: analyzing in sub @ 0x%05x\n", SUBSADDR(sr));

	for(i = 0; i < USED_REGS_SIZE; i++)
		sr->used_regs[i] = 0;

	for(i = sr->sidx; i <= sr->eidx; i++)
	{
		instr_t *inst = &(sr->er->instrs[i]);

		//Check instruction type and mark used registers.
		switch(inst->type)
		{
			case SPU_INSTR_RR:
				bmap_set_bit(sr->used_regs, inst->rr.ra);
				bmap_set_bit(sr->used_regs, inst->rr.rb);
				bmap_set_bit(sr->used_regs, inst->rr.rt);
				break;
			case SPU_INSTR_RRR:
				bmap_set_bit(sr->used_regs, inst->rrr.ra);
				bmap_set_bit(sr->used_regs, inst->rrr.rb);
				bmap_set_bit(sr->used_regs, inst->rrr.rc);
				bmap_set_bit(sr->used_regs, inst->rrr.rt);
				break;
			case SPU_INSTR_RI7:
				bmap_set_bit(sr->used_regs, inst->ri7.ra);
				bmap_set_bit(sr->used_regs, inst->ri7.rt);
				break;
			case SPU_INSTR_RI10:
				bmap_set_bit(sr->used_regs, inst->ri10.ra);
				bmap_set_bit(sr->used_regs, inst->ri10.rt);
				break;
			case SPU_INSTR_RI16:
				bmap_set_bit(sr->used_regs, inst->ri16.rt);
				break;
			case SPU_INSTR_RI18:
				bmap_set_bit(sr->used_regs, inst->ri18.rt);
				break;
		}
	}
}

void registers_analyze_all(ctxt_t *ctxt)
{
	list<subroutine_t *>::iterator it;

	//Analyze all subroutines.
	for(it = ctxt->subroutines.begin(); it != ctxt->subroutines.end(); ++it)
		_registers_analyze_subroutine(*it);
}
