/*
* ps3 bd game disk keygen
* Copyright (c) 2011-2012 by naehrwert
* This file is released under the GPLv2.
*/

#include "types.h"
#include "aes.h"

#include <string.h>

/*! Debug disk ID. */
#define DEBUG_DISC_ID "PS3_L_DEBUG_DISC"
/*! Generated key length. */
#define GEN_KEY_LEN 0x10
/*! Keygen key length. */
#define KEYGEN_KEY_LEN 0x10
/*! Keygen iv length. */
#define KEYGEN_IV_LEN 0x10
/*! Key bits. */
#define KEY_BITS(klen) (klen * 8)

/*! Keygen key. */
u8 keygen_key[KEYGEN_KEY_LEN] = {/* insert keygen key here */};
/*! Keygen iv. */
u8 keygen_iv[KEYGEN_IV_LEN] = {/* insert keygen iv here */};
/*! Debug disc key. */
u8 debug_disk_key[GEN_KEY_LEN] = {/* insert debug disc key here */;

void keygen_from_disk_magic(u8 *disk_magic, u8 *key_out)
{
	if(memcmp(disk_magic, DEBUG_DISC_ID) == 0)
		memcpy(key_out, debug_disk_key);
	else
	{
		aes_context aes_ctxt;
		aes_setkey_enc(&aes_ctxt, keygen_key, KEY_BITS(KEYGEN_KEY_LEN));
		aes_crypt_cbc(&aes_ctxt, AES_ENCRYPT, GEN_KEY_LEN, keygen_iv, disk_magic, key_out);
	}
}
