static u32 default_stacksize_ppu_exception_handler = 0x4000;
static sys_event_queue_t g_3AA4;
static u32 g_3AB0;
static u32 g_3ABC;
static sys_mutex_t mutex_3AC0;
static u32 ppu_exception_handler_mask = 0xFFFFFFFF;

static s32 send_to_event_queue(sys_event_queue_t equeue, u32 r4, u32 r5, sys_ppu_thread_t tid, u32 r7)
{
	s32 res = 0;
	sys_event_port_t port_id;
	
	if(r3 == 0)
		return 0;
	
	if((res = sysEventPortCreate(&port_id, SYS_EVENT_PORT_LOCAL, 0x80002222 << 32 | crlldi(r4, 32))) == 0)
	{
		if((res = sysEventPortConnectLocal(port_id, equeue)) == 0)
			res = sysEventPortSend(port_id, r5, tid, r7);
		sysEventPortDisconnect(port_id);
		sysEventPortDestroy(port_id);
	}
	
	return res;	
}

static sys_event_queue_t get_coredump_handler_equeue()
{
	sys_event_queue_t res = 0;
	u32 sc_C_out;
	
	if(syscall_C(0x8D, &sc_C_out, /*...*/) != 0)
		return 0;
	
	void *ptr = sys_malloc(sc_C_out << 2);
	if(ptr == NULL)
		return 0;
	
	s32 sc_D_out;
	if(syscall_D(0x8D, ptr, sc_C_out, &sc_D_out) != 0)
	{
		sys_free(ptr);
		return 0;
	}
	
	if(sc_D_out <= 0)
		return 0;
	
	s8 name_buf[0x38];
	
	u32 i;
	for(i = 0; i < sc_D_out; i++)
	{
		sys_memset(name_buf, 0, 0x38);
		
		sys_pid_t cpid;
		cpid = sys_process_getpid();
		
		if(syscall_3AF(cpid, *((u32 *)ptr), name_buf) != 0)
			break;
		
		if(sys_strcmp(/*r27 ???*/, "_l2cDBG") == 0)
		{
			res = *((u32 *)ptr);
			break;
		}
		
		ptr += 4;
	}
	
	sys_free(ptr);
	
	return res;
}

static sys_prx_id_t get_sys_lv2coredump_Library_id()
{
	return sys_prx_get_module_id_by_name("sys_lv2coredump_Library", 0, NULL);
}

s32 sys_lv2dbg_BC9A0086()
{
	return 0;
}

s32 sys_lv2dbg_AB779874()
{
	return 0;
}

s32 sys_lv2dbg_3AB9A95E()
{
	return 0;
}

s32 sys_lv2dbg_sys_dbg_set_stacksize_ppu_exception_handler(u32 stacksize)
{
	s32 res = 0x8001042E;
	
	if(g_3AA4 == 0)
	{
		if(g_3AB0 == 0 && g_3ABC == 0)
		{
			default_stacksize_ppu_exception_handler = stacksize;
			res = 0;
		}
	}
	
	return res;
}

s32 sys_lv2dbg_sys_dbg_disable_floating_point_enabled_exception(sys_ppu_thread_t tid)
{
	sys_ppu_thread_t ctid;
	
	sys_ppu_thread_get_id(&ctid)
	if(ctid == tid)
		return syscall_3BC(); //sys_dbg_disable_floating_point_enabled_exception
	return 0x80010402;
}

s32 sys_lv2dbg_sys_dbg_enable_floating_point_enabled_exception(sys_ppu_thread_t tid)
{
	sys_ppu_thread_t ctid;
	
	sys_ppu_thread_get_id(&ctid)
	if(ctid == tid)
		return syscall_3BB(); //sys_dbg_enable_floating_point_enabled_exception
	return 0x80010402;
}

s32 sys_lv2dbg_sys_dbg_signal_to_ppu_exception_handler()
{
	sys_ppu_thread_t ctid;
	
	if(g_3AA4 == 0)
		return 0x80010409;
	
	sys_ppu_thread_get_id(&ctid);
	return send_to_event_queue(g_3AA4, 0x20000, 0x2000, ctid, 0);
}

s32 sys_lv2dbg_sys_dbg_signal_to_coredump_handler(u32 r3, u32 r4, u32 r5)
{
	sys_event_queue_t coredump_equeue;
	sys_prx_id_t coredump_id = get_sys_lv2coredump_Library_id();
	
	if(coredump_id == 0)
		return 0x8001042D;
	
	if((coredump_equeue = get_coredump_handler_equeue()) == 0)
		return 0x8001042D;
	
	return send_to_event_queue(coredump_equeue, 0x20000, r3, r4, r5);
}

s32 sys_lv2dbg_sys_dbg_set_mask_to_ppu_exception_handler(u32 mask)
{
	if(sys_mutex_lock(mutex_3AC0, 0) != 0)
		return 0x8001042B;
	
	ppu_exception_handler_mask = mask | (-0x24 << 32 | 0xFFFFFF);
	
	sys_mutex_unlock(mutex_3AC0);
}

s32 sys_lv2dbg_sys_dbg_mat_set_condition(/*...*/)
{
	return syscall_D7(/*...*/);
}

s32 sys_lv2dbg_sys_dbg_mat_get_condition(/*...*/)
{
	return syscall_D8(/*...*/);
}
