#!/bin/bash
#
# Copyright (C) 2012 glevand <geoffrey.levand@mail.ru>
# All rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

PS3PHYSMEM=ps3physmem

write()
{
	local offset=$1
	local data=`echo "$2" | sed -e 's/\(..\)/\\\\x\1/g'`

	echo -ne "$data" | dd of=/dev/$PS3PHYSMEM bs=1 seek=$(($offset))
}

GPU_IO_PAGE_SIZE_OFFSET_355=0x214990

GPU_IO_PAGE_SIZE_PATCH_355="38001000"

GPU_IO_PAGE_SIZE_RESTORE_355="3c000001"

if [ $# -ne 1 ]; then
	echo "usage: $0 <patch|restore>" >&2
	exit 1
fi

if [ ! -e /dev/$PS3PHYSMEM ]; then
	modprobe $PS3PHYSMEM
fi

if [ ! -e /dev/$PS3PHYSMEM ]; then
	echo "ERROR: could not find /dev/$PS3PHYSMEM" >&2
	exit 1
fi

case $1 in
	patch)
		write $GPU_IO_PAGE_SIZE_OFFSET_355 $GPU_IO_PAGE_SIZE_PATCH_355
	;;
	restore)
		write $GPU_IO_PAGE_SIZE_OFFSET_355 $GPU_IO_PAGE_SIZE_RESTORE_355
	;;
	*)
		echo "usage: $0 <patch|restore>" >&2
		exit 1
	;;
esac

exit 0
