#!/bin/bash
#
# Copyright (C) 2012 glevand <geoffrey.levand@mail.ru>
# All rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

PS3PHYSMEM=ps3physmem

write()
{
	local offset=$1
	local data=`echo "$2" | sed -e 's/\(..\)/\\\\x\1/g'`

	echo -ne "$data" | dd of=/dev/$PS3PHYSMEM bs=1 seek=$(($offset))
}

SET_LAID_OFFSET_355=0x16f3bc
CHECK_SS_ID_OFFSET_355=0x16f3e0
SEND_SPM_REQ_OFFSET_355=0x16f458

SET_LAID_PATCH_355="60000000"
CHECK_SS_ID_PATCH_355="38600001"
SEND_SPM_REQ_PATCH_355="3be000019be1007038600000"

SET_LAID_RESTORE_355="f8010098"
CHECK_SS_ID_RESTORE_355="4bfff0e5"
SEND_SPM_REQ_RESTORE_355="38a100709be1007048005fa5"

if [ $# -ne 1 ]; then
	echo "usage: $0 <patch|restore>" >&2
	exit 1
fi

if [ ! -e /dev/$PS3PHYSMEM ]; then
	modprobe $PS3PHYSMEM
fi

if [ ! -e /dev/$PS3PHYSMEM ]; then
	echo "ERROR: could not find /dev/$PS3PHYSMEM" >&2
	exit 1
fi

case $1 in
	patch)
		write $SET_LAID_OFFSET_355 $SET_LAID_PATCH_355
		write $CHECK_SS_ID_OFFSET_355 $CHECK_SS_ID_PATCH_355
		write $SEND_SPM_REQ_OFFSET_355 $SEND_SPM_REQ_PATCH_355
	;;
	restore)
		write $SET_LAID_OFFSET_355 $SET_LAID_RESTORE_355
		write $CHECK_SS_ID_OFFSET_355 $CHECK_SS_ID_RESTORE_355
		write $SEND_SPM_REQ_OFFSET_355 $SEND_SPM_REQ_RESTORE_355
	;;
	*)
		echo "usage: $0 <patch|restore>" >&2
		exit 1
	;;
esac

exit 0
