#!/bin/sh
#
# Copyright (C) 2012 glevand <geoffrey.levand@mail.ru>
# All rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#

PS3SED=ps3sed
GAMEOS_LAID=0x1070000002000001
BEGIN_PAD=8
END_PAD=8

disk_dev_id=`$PS3SED print_device | grep disk | awk '{ print $2 }'`

echo "INFO: device id $disk_dev_id"

disk_num_regs=`$PS3SED print_region $disk_dev_id | wc -l`

echo "INFO: number of regions $disk_num_regs"

if [ "$disk_num_regs" != "3" ]; then
	echo "ERROR: invalid number of regions, expected 3" >&2
	exit 1
fi

disk_total_size=`$PS3SED print_region $disk_dev_id | sed -ne '1p' | awk '{ print $3 }'`

echo "INFO: total number of blocks $disk_total_size"

disk_last_reg_start=`$PS3SED print_region $disk_dev_id | sed -ne '3p' | awk '{ print $2 }'`
disk_last_reg_size=`$PS3SED print_region $disk_dev_id | sed -ne '3p' | awk '{ print $3 }'`

echo "INFO: last region start block $disk_last_reg_start"
echo "INFO: last region number of blocks $disk_last_reg_size"

disk_new_reg_start=`expr $disk_last_reg_start + $disk_last_reg_size + $BEGIN_PAD`

echo "INFO: new region start block $disk_new_reg_start"

if [ $disk_new_reg_start -ge $disk_total_size ]; then
	echo "ERROR: no free space left" >&2
	exit 1
fi

disk_new_reg_size=`expr $disk_total_size - $disk_new_reg_start - $END_PAD`

echo "INFO: new region number of blocks $disk_new_reg_size"

disk_new_reg_id=`$PS3SED create_region $disk_dev_id $disk_new_reg_start $disk_new_reg_size $GAMEOS_LAID`

if [ $? -ne 0 ]; then
	echo "ERROR: could not create new region" >&2
	exit 1
fi

echo "INFO: new region id $disk_new_reg_id" >&2

exit 0
