/*-
 * Copyright (C) 2012 glevand <geoffrey.levand@mail.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _JSTAVAR_H
#define _JSTAVAR_H

#define JSTA_CONFIG_INDEX	0
#define JSTA_IFACE_INDEX	4

enum {
	JSTA_RX,
	JSTA_TX,
	JSTA_N_XFERS,
};

#define JSTA_RX_BUFSZ		2048
#define JSTA_TX_BUFSZ		2048
#define JSTA_CMD_BUFSZ		2048

struct jsta_scan_result {
	TAILQ_ENTRY(jsta_scan_result) sr_queue;

	uint8_t sr_bssid[IEEE80211_ADDR_LEN];
	uint16_t sr_capinfo;
	uint16_t sr_intval;
	uint8_t sr_rssi;

	uint8_t *sr_ie_ssid;
	uint8_t *sr_ie_dsparms;
	uint8_t *sr_ie_rates;
	uint8_t *sr_ie_xrates;
	uint8_t *sr_ie_erp;

	unsigned int sr_ie_len;
	uint8_t sr_ie[0];
};

struct jsta_softc {
	device_t sc_dev;

	struct usb_device *sc_udev;
	struct mtx sc_mtx;
	struct usb_xfer *sc_xfer[JSTA_N_XFERS];

	uint8_t sc_mac_addr[ETHER_ADDR_LEN];
	uint16_t sc_chan_info;
	int sc_nchans;

	struct ifnet *sc_ifp;
	struct ifmedia sc_ifmedia;

	struct jpt_event_listener sc_el;

	TAILQ_HEAD(, jsta_scan_result) sc_srq;

	uint32_t sc_iflags;

	char sc_ssid[IEEE80211_NWID_LEN];
	int sc_ssid_len;

	char sc_stationname[IEEE80211_NWID_LEN];
	int sc_stationname_len;

	uint8_t sc_chanlist[IEEE80211_CHAN_BYTES];

	uint8_t sc_des_bssid[IEEE80211_ADDR_LEN];

	struct ieee80211_wepkey sc_key[IEEE80211_WEP_NKID];
	ieee80211_keyix sc_def_txkey;

	u_int sc_scanvalid;

	int sc_associated;
};

#endif /* _JSTAVAR_H */
