/*-
 * Copyright (C) 2012 glevand <geoffrey.levand@mail.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _JPTVAR_H
#define _JPTVAR_H

#define JPT_CONFIG_INDEX	0
#define JPT_IFACE_INDEX		3

enum {
	JPT_IRQ_RX,
	JPT_CMD_TX,
	JPT_N_XFERS,
};

#define JPT_IRQ_BUFSZ		2048
#define JPT_CMD_BUFSZ		2048

struct jpt_event {
	TAILQ_ENTRY(jpt_event) e_queue;

	struct ps3_eurus_event e_eurus_event;
};

struct jpt_softc {
	device_t sc_dev;

	struct usb_device *sc_udev;
	struct mtx sc_mtx;
	struct usb_xfer *sc_xfer[JPT_N_XFERS];

	TAILQ_HEAD(, jpt_event_listener) sc_elq;

	TAILQ_HEAD(, jpt_event) sc_eq;
	struct task sc_event_task;
	struct taskqueue *sc_tq;

	struct mtx sc_elq_mtx;
	struct jpt_event_listener sc_el;

	uint16_t sc_dev_status;
	uint8_t sc_mac_addr[ETHER_ADDR_LEN];
	uint64_t sc_chan_info;

	int sc_dev_ready;

	int sc_cmd_busy;
	uint16_t sc_cmd_tag;
	uint16_t sc_eurus_cmd;
	uint16_t sc_eurus_tag;
	int sc_cmd_len;
	int sc_cmd_err;

	char *sc_irq_buf;
	char *sc_cmd_buf;
};

enum jpt_pkt_type {
	JPT_PKT_CMD	= 6,
	JPT_PKT_EVENT	= 8,
};

struct jpt_pkt_hdr {
	uint8_t unknown1;
	uint8_t unknown2;
	uint8_t type;
} __packed;

struct jpt_cmd_hdr {
	uint8_t unknown1;
	uint16_t unknown2;
	uint8_t res1[2];
	uint16_t tag;
	uint8_t res2[14];
} __packed;

struct jpt_event_hdr {
	uint8_t count;
} __packed;

#define LV1_SB_BUS_ID		0x1
#define LV1_GELIC_DEV_ID	0x0
#define LV1_GET_MAC_ADDRESS	0x1
#define LV1_GET_CHANNEL_INFO	0x6

#endif /* _JPTVAR_H */
