/*-
 * Copyright (C) 2011, 2012 glevand <geoffrey.levand@mail.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer,
 *    without modification, immediately at the beginning of the file.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#include <stdint.h>

uint32_t reset_gpu_state[] = {
	0x00042000,
	0x31337303,

	0x00042180,
	0x66604200,

	0x00082184,
	0xfeed0001,
	0xfeed0000,

	0x00044000,
	0x3137c0de,

	0x00044180,
	0x66604200,

	0x00084184,
	0xfeed0000,
	0xfeed0001,

	0x00046000,
	0x313371c3,

	0x00046180,
	0x66604200,

	0x00046184,
	0xfeed0000,

	0x00046188,
	0xfeed0000,

	0x0004a000,
	0x31337808,

	0x0020a180,
	0x66604200,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x313371c3,

	0x0008a2fc,
	0x00000003,
	0x00000004,

	0x00048000,
	0x31337a73,

	0x00048180,
	0x66604200,

	0x00048184,
	0xfeed0000,

	0x0004c000,
	0x3137af00,

	0x0004c180,
	0x66604200,

	0x00000000,

	0x00020000,
};

int reset_gpu_state_size = sizeof(reset_gpu_state);

uint32_t reset_gpu_state_3d[] = {
	/* These commands are executed every time after flip to reset GPU state !!! */

	/* program 1 */

	0x00040000,
	0x31337000,

	0x003c0180,
	0x66604200,
	0xfeed0000,
	0xfeed0001,
	0xfeed0000,
	0x00000000,
	0xfeed0000,
	0xfeed0000,
	0xfeed0000,
	0xfeed0001,
	0x66606660,
	0x66626660,
	0x00000000,
	0x00000000,
	0xfeed0000,
	0xfeed0000,

	0x00040060,
	0x66616661,

	0x00340200,
	0x00000000,
	0x00000000,
	0x00000121,
	0x00000040,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000040,
	0x00000001,
	0x00000080,
	0x00000100,
	0x00000040,
	0x00000000,

	0x00100280,
	0x00000040,
	0x00000040,
	0x00000000,
	0x00000000,

	0x00041d80,
	0x00000003,

	0x004802b8,
	0x00000000,
	0x00000000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,
	0x0fff0000,

	0x00081d98,
	0x0fff0000,
	0x0fff0000,

	0x00041da4,
	0x00000000,

	0x000403b0,
	0x00100000,

	0x00041454,
	0x00000000,

	0x00041ff4,
	0x003fffff,

	0x00181fc0,
	0x00000000,
	0x06144321,
	0xedcba987,
	0x0000006f,
	0x00171615,
	0x001b1a19,

	0x00280b40,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,

	0x00040a0c,
	0x00000000,

	0x000c0a60,
	0x00000000,
	0x00000000,
	0x00000000,

	0x00080a78,
	0x00000000,
	0x00000000,

	0x00041428,
	0x00000001,

	0x00041d88,
	0x00001000,

	0x00041e94,
	0x00000011,

	0x00041450,
	0x00080003,

	0x00041d64,
	0x02000000,

	0x0004145c,
	0x00000001,

	0x00041fe0,
	0x00000001,

	0x00400b00,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,
	0x00002dc8,

	0x001008cc,
	0x00000800,
	0x00000000,
	0x00000000,
	0x00000000,

	0x00100240,
	0x0000ffff,
	0x00000000,
	0x00000000,
	0x00000000,

	0x00c003c0,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00010101,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x00007421,
	0x9aabaa98,
	0x66666789,
	0x98766666,
	0x89aabaa9,
	0x99999999,
	0x88888889,
	0x98888888,
	0x99999999,
	0x56676654,
	0x33333345,
	0x54333333,
	0x45667665,
	0xaabbba99,
	0x66667899,
	0x99876666,
	0x99abbbaa,

	0x00081738,
	0x00000000,
	0x00000000,

	0x0004e000,
	0xcafebabe,

	/* program 2 */

	0x00080308,
	0x00000207,
	0x00000000,

	0x00040304,
	0x00000000,

	0x000c0350,
	0x00000207,
	0x00000000,
	0x000000ff,

	0x0004034c,
	0x000000ff,

	0x000c035c,
	0x00001e00,
	0x00001e00,
	0x00001e00,

	0x0004031c,
	0x00000000,

	0x0004037c,
	0x00000000,

	0x00040310,	/* blend control */
	0x00000000,	/* disable */

	0x0004036c,
	0x00000000,

	0x00040320,
	0x80068006,

	0x00080314,
	0x00010001,
	0x00000000,

	0x00041d8c,
	0xffffff00,

	0x00041d94,
	0x00000000,

	0x00040100,
	0x00000000,

	0x00040324,
	0x01010101,

	0x0004183c,
	0x00000000,

	0x00041830,
	0x00000405,

	0x00080384,
	0x00000000,
	0x3f800000,

	0x00040380,
	0x00000000,

	0x00040a6c,
	0x00000201,

	0x00040a70,
	0x00000001,

	0x00040a74,
	0x00000000,

	0x00040300,
	0x00000001,

	0x00041fec,
	0x00000000,

	0x00041fc0,
	0x00000000,

	0x00041834,	/* set front face mode */
	0x00000901,	/* ccw */

	0x000403b8,
	0x00000008,

	0x00040374,	/* logic op control */
	0x00000000,	/* disable */

	0x00040378,	/* set logic op */
	0x00001503,	/* copy */

	0x00041ee0,
	0x3f800000,

	0x00040a68,
	0x00000000,

	0x00080a78,
	0x00000000,
	0x00000000,

	0x00041dac,
	0x00000000,

	0x00041db0,
	0xffffffff,

	0x000808c0,
	0x10000000,
	0x10000000,

	0x00040368,	/* set shade model */
	0x00001d01,	/* smooth */

	0x000c0330,
	0x00000207,
	0x00000000,
	0x000000ff,

	0x0004032c,
	0x000000ff,

	0x000c033c,
	0x00001e00,
	0x00001e00,
	0x00001e00,

	0x00040328,
	0x00000000,

	0x00041a08,
	0x00030101,

	0x00041a1c,
	0x00000000,

	0x00041a0c,
	0x00060000,

	0x00041a14,
	0x02052000,

	0x00041a28,
	0x00030101,

	0x00041a3c,
	0x00000000,

	0x00041a2c,
	0x00060000,

	0x00041a34,
	0x02052000,

	0x00041a48,
	0x00030101,

	0x00041a5c,
	0x00000000,

	0x00041a4c,
	0x00060000,

	0x00041a54,
	0x02052000,

	0x00041a68,
	0x00030101,

	0x00041a7c,
	0x00000000,

	0x00041a6c,
	0x00060000,

	0x00041a74,
	0x02052000,

	0x00041a88,
	0x00030101,

	0x00041a9c,
	0x00000000,

	0x00041a8c,
	0x00060000,

	0x00041a94,
	0x02052000,

	0x00041aa8,
	0x00030101,

	0x00041abc,
	0x00000000,

	0x00041aac,
	0x00060000,

	0x00041ab4,
	0x02052000,

	0x00041ac8,
	0x00030101,

	0x00041adc,
	0x00000000,

	0x00041acc,
	0x00060000,

	0x00041ad4,
	0x02052000,

	0x00041ae8,
	0x00030101,

	0x00041afc,
	0x00000000,

	0x00041aec,
	0x00060000,

	0x00041af4,
	0x02052000,

	0x00041b08,
	0x00030101,

	0x00041b1c,
	0x00000000,

	0x00041b0c,
	0x00060000,

	0x00041b14,
	0x02052000,

	0x00041b28,
	0x00030101,

	0x00041b3c,
	0x00000000,

	0x00041b2c,
	0x00060000,

	0x00041b34,
	0x02052000,

	0x00041b48,
	0x00030101,

	0x00041b5c,
	0x00000000,

	0x00041b4c,
	0x00060000,

	0x00041b54,
	0x02052000,

	0x00041b68,
	0x00030101,

	0x00041b7c,
	0x00000000,

	0x00041b6c,
	0x00060000,

	0x00041b74,
	0x02052000,

	0x00041b88,
	0x00030101,

	0x00041b9c,
	0x00000000,

	0x00041b8c,
	0x00060000,

	0x00041b94,
	0x02052000,

	0x00041ba8,
	0x00030101,

	0x00041bbc,
	0x00000000,

	0x00041bac,
	0x00060000,

	0x00041bb4,
	0x02052000,

	0x00041bc8,
	0x00030101,

	0x00041bdc,
	0x00000000,

	0x00041bcc,
	0x00060000,

	0x00041bd4,
	0x02052000,

	0x00041be8,
	0x00030101,

	0x00041bfc,
	0x00000000,

	0x00041bec,
	0x00060000,

	0x00041bf4,
	0x02052000,

	0x00040348,
	0x00000000,

	0x00041740,
	0x00000002,

	0x00041680,
	0x00000000,

	0x00041744,
	0x00000002,

	0x00041684,
	0x00000000,

	0x00041748,
	0x00000002,

	0x00041688,
	0x00000000,

	0x0004174c,
	0x00000002,

	0x0004168c,
	0x00000000,

	0x00041750,
	0x00000002,

	0x00041690,
	0x00000000,

	0x00041754,
	0x00000002,

	0x00041694,
	0x00000000,

	0x00041758,
	0x00000002,

	0x00041698,
	0x00000000,

	0x0004175c,
	0x00000002,

	0x0004169c,
	0x00000000,

	0x00041760,
	0x00000002,

	0x000416a0,
	0x00000000,

	0x00041764,
	0x00000002,

	0x000416a4,
	0x00000000,

	0x00041768,
	0x00000002,

	0x000416a8,
	0x00000000,

	0x0004176c,
	0x00000002,

	0x000416ac,
	0x00000000,

	0x00041770,
	0x00000002,

	0x000416b0,
	0x00000000,

	0x00041774,
	0x00000002,

	0x000416b4,
	0x00000000,

	0x00041778,
	0x00000002,

	0x000416b8,
	0x00000000,

	0x0004177c,
	0x00000002,

	0x000416bc,
	0x00000000,

	0x00080a00,
	0x10000000,
	0x10000000,
	0x00080394,
	0x00000000,
	0x3f800000,

	0x00200a20,
	0x45000000,
	0x45000000,
	0x3f000000,
	0x00000000,
	0x45000000,
	0x45000000,
	0x3f000000,
	0x00000000,

	0x00200a20,
	0x45000000,
	0x45000000,
	0x3f000000,
	0x00000000,
	0x45000000,
	0x45000000,
	0x3f000000,
	0x00000000,

	0x00041d7c,
	0xffff0000,

	0x0004182c,
	0x00001b02,

	0x00041d90,
	0x00000000,

	0x00040370,
	0x00000000,

	0x00041828,
	0x00001b02,

	0x000403bc,
	0x00000000,

	0x00041db4,
	0x00000000,

	0x00041ee4,
	0x00000000,

	0x00041ee8,
	0x00000000,

	0x00041838,
	0x00000000,

	0x0004147c,
	0x00000000,

	0x00041e98,
	0x01000000,

	0x00041478,
	0x00000000,

	0x00041ff0,
	0x0000ffff,

	0x000417cc,
	0x00000000,

	0x00040908,
	0x00000101,

	0x0004091c,
	0x00000000,

	0x0004090c,
	0x00060000,

	0x00040914,
	0x00000000,

	0x00040928,
	0x00000101,

	0x0004093c,
	0x00000000,

	0x0004092c,
	0x00060000,

	0x00040934,
	0x00000000,

	0x00040948,
	0x00000101,

	0x0004095c,
	0x00000000,

	0x0004094c,
	0x00060000,

	0x00040954,
	0x00000000,

	0x00040968,
	0x00000101,

	0x0004097c,
	0x00000000,

	0x0004096c,
	0x00060000,

	0x00040974,
	0x00000000,

	0x00040238,
	0x00000000,

	0x00041d78,
	0x00000001,

	0x0004142c,
	0x00000000,

	0x00041ff8,
	0x00000000,

	0x00041fe8,
	0x00000000,

	/* program 3 */

	0x00042000,
	0x31337303,

	0x000c2180,
	0x66604200,
	0xfeed0001,
	0xfeed0000,

	0x00046000,
	0x313371c3,

	0x000c6180,
	0x66604200,
	0xfeed0000,
	0xfeed0000,

	0x0004a000,
	0x31337808,

	0x0020a180,
	0x66604200,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x313371c3,

	0x0008a2fc,
	0x00000003,
	0x00000004,

	0x00048000,
	0x31337a73,

	0x00088180,
	0x66604200,
	0xfeed0000,

	0x0004c000,
	0x3137af00,

	0x0004c180,
	0x66604200,

	0x00020000,	/* return */
};

int reset_gpu_state_3d_size = sizeof(reset_gpu_state_3d);
