/*-
 * Copyright (c) 2013 glevand <geoffrey.levand@mail.ru>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef	_G_AES_XTS_H_
#define	_G_AES_XTS_H_

#define	G_AES_XTS_CLASS_NAME	"AES_XTS"
#define	G_AES_XTS_VERSION	1
#define	G_AES_XTS_SUFFIX	".aes_xts"

#define G_AES_XTS_128_KEYSIZE	32
#define G_AES_XTS_256_KEYSIZE	64

#ifdef _KERNEL

#define	G_AES_XTS_DEBUG(lvl, ...)	do {				\
	if (g_aes_xts_debug >= (lvl)) {					\
		printf("GEOM_AES_XTS");					\
		if (g_aes_xts_debug > 0)				\
			printf("[%u]", lvl);				\
		printf(": ");						\
		printf(__VA_ARGS__);					\
		printf("\n");						\
	}								\
} while (0)

#define	G_AES_XTS_LOGREQ(lvl, bp, ...)	do {				\
	if (g_aes_xts_debug >= (lvl)) {					\
		printf("GEOM_AES_XTS");					\
		if (g_aes_xts_debug > 0)				\
			printf("[%u]", lvl);				\
		printf(": ");						\
		printf(__VA_ARGS__);					\
		printf(" ");						\
		g_print_bio(bp);					\
		printf("\n");						\
	}								\
} while (0)

#define G_AES_XTS_FLAG_DESTROY		0x00000001
#define G_AES_XTS_FLAG_WORKER_DONE	0x00000002

struct g_aes_xts_softc {
	u_int sc_flags;
	u_char sc_key[G_AES_XTS_256_KEYSIZE];
	int sc_keylen;
	u_int64_t sc_crypto_sid;
	struct bio_queue_head sc_bioq;
	struct mtx sc_bioq_lock;
	struct proc *sc_proc;
};

#endif	/* _KERNEL */

#endif	/* _G_AES_XTS_H_ */
