#ifndef _UTIL_H_
#define _UTIL_H_

#include <stdlib.h>

#include "netrpc.h"
#include "lv1.h"

/*!
* \brief Write u32 value.
*/
static inline s64 write_u32(netrpc_ctxt_t *ctxt, u64 addr, u32 value)
{
	u32 v = _ES32(value);
	return netrpc_writemem(ctxt, addr, &v, sizeof(u32));
}

/*!
* \brief Read u32 value.
*/
static inline s64 read_u32(netrpc_ctxt_t *ctxt, u64 addr, u32 *value)
{
	u32 v;
	s64 res = netrpc_readmem(ctxt, addr, &v, sizeof(u32), NULL);
	*value = _ES32(v);
	return res;
}

/*!
* \brief Write u64 value.
*/
static inline s64 write_u64(netrpc_ctxt_t *ctxt, u64 addr, u64 value)
{
	u64 v = _ES64(value);
	return netrpc_writemem(ctxt, addr, &v, sizeof(u64));
}

/*!
* \brief Read u64 value.
*/
static inline s64 read_u64(netrpc_ctxt_t *ctxt, u64 addr, u64 *value)
{
	u64 v;
	s64 res = netrpc_readmem(ctxt, addr, &v, sizeof(u64), NULL);
	*value = _ES64(v);
	return res;
}

/*!
* \brief Reboot the console and close the connection.
*/
static inline s64 reboot_console(netrpc_ctxt_t *ctxt)
{
	//Call lv1_panic.
	u64 arg_in[] = {1};
	netrpc_hvcall(&ctxt, _N_lv1_panic, arg_in, 1, NULL, 0);
	
	//Close the connection.
	netrpc_close(&ctxt);
}

#endif
