#ifndef _TYPES_H_
#define _TYPES_H_

typedef char s8;
typedef short s16;
typedef int s32;
typedef long long s64;

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef unsigned long long u64;

#define _ARRAY_CNT(arr, type) (sizeof(arr)/sizeof(type))

//Endian swap for u32.
#define _ES32(val) ((((val) & 0xff000000) >> 24) | \
                    (((val) & 0x00ff0000) >> 8 ) | \
                    (((val) & 0x0000ff00) << 8 ) | \
                    (((val) & 0x000000ff) << 24))

//Endian swap for u64.
#define _ES64(val) ((((val) & 0xff00000000000000ull) >> 56) | \
                    (((val) & 0x00ff000000000000ull) >> 40) | \
                    (((val) & 0x0000ff0000000000ull) >> 24) | \
                    (((val) & 0x000000ff00000000ull) >> 8 ) | \
                    (((val) & 0x00000000ff000000ull) << 8 ) | \
                    (((val) & 0x0000000000ff0000ull) << 24) | \
                    (((val) & 0x000000000000ff00ull) << 40) | \
                    (((val) & 0x00000000000000ffull) << 56))

#endif
