#ifndef _SPU_H_
#define _SPU_H_

#include "types.h"
#include "netrpc.h"

/*! SPU privlege 1 registers. (u64) */
#define _OFFSET_MFC_SR1 0x0000
#define _OFFSET_INT_Stat_class0 0x0140
#define _OFFSET_INT_Stat_class1 0x0148
#define _OFFSET_INT_Stat_class2 0x0150
#define _OFFSET_MFC_DSISR 0x0610
#define _OFFSET_MFC_DAR 0x0620
#define _OFFSET_MFC_DSIPR 0x0800
#define _OFFSET_MFC_LSCRR 0x0810
#define _OFFSET_MFC_CER 0x0c00
#define _OFFSET_EXECUTION_STATUS 0x0f00
#define _OFFSET_TRANSITION_NOTIFIER 0x0f10

/*! SPU privlege 2 registers. (u64) */
#define _OFFSET_SLB_Index 0x1108
#define _OFFSET_SLB_ESID 0x1110
#define _OFFSET_SLB_VSID 0x1118
#define _OFFSET_SLB_Invalidate_Entry 0x1120
#define _OFFSET_SLB_Invalidate_All 0x1128
#define _OFFSET_SPU_OutIntrMbox 0x4000
#define _OFFSET_SPU_PrivCntl 0x4040
#define _OFFSET_SPU_ChnlIndex 0x4060
#define _OFFSET_SPU_ChnlCnt 0x4068
#define _OFFSET_SPU_ChnlData 0x4070
#define _OFFSET_SPU_Cfg 0x4078

/*! SPU problem registers. (u32) */
#define _OFFSET_MFC_LSA 0x3004
#define _OFFSET_MFC_EAH 0x3008
#define _OFFSET_MFC_EAL 0x300c
#define _OFFSET_MFC_Size 0x3010
#define _OFFSET_MFC_Tag 0x3010
#define _OFFSET_MFC_ClassID_CMD 0x3014
#define _OFFSET_MFC_CMDStatus 0x3014
#define _OFFSET_MFC_QStatus 0x3104
#define _OFFSET_Prxy_QueryType 0x3204
#define _OFFSET_Prxy_QueryMask 0x321c
#define _OFFSET_Prxy_TagStatus 0x322c
#define _OFFSET_SPU_Out_Mbox 0x4004
#define _OFFSET_SPU_In_Mbox 0x400c
#define _OFFSET_SPU_Mbox_Stat 0x4014
#define _OFFSET_SPU_RunCntl 0x401c
#define _OFFSET_SPU_Status 0x4024
#define _OFFSET_SPU_NPC 0x4034
#define _OFFSET_SPU_Sig_Notify_1 0x1400c
#define _OFFSET_SPU_Sig_Notify_2 0x1c00c

/*! Register adress macros. */
#define SPU_RADDR(base, offset) (base + offset)

/*! Max. SPU SLB entries. */
#define SPU_SLB_MAX_ENTRIES 8

/*! SPU_RunCntl values. */
#define SPU_RunCntl_STOP_REQ 0x0
#define SPU_RunCntl_RUN_REQ 0x1
#define SPU_RunCntl_ISOLATION_EXIT_REQ 0x2
#define SPU_RunCntl_ISOLATION_REQ 0x3

/*! SPU_Status bits. */
/*! SPU is running. */
#define SPU_Status_R (1<<0)
/*! SPU stopped due to a Stop and Signal instruction. */
#define SPU_Status_P (1<<1)
/*! SPU is halted due to a halt instruction. */
#define SPU_Status_H (1<<2)
/*! SPU is waiting on a blocked channel. */
#define SPU_Status_W (1<<3)
/*! SPU single step status. */
#define SPU_Status_S (1<<4)
/*! Invalid instruction detected. */
#define SPU_Status_I (1<<5)

void spu_slb_invalidate_all(netrpc_ctxt_t *ctxt, u64 spu_priv2);
s32 spu_slb_set_entry(netrpc_ctxt_t *ctxt, u64 spu_priv2, u64 index, u64 esid, u64 vsid);
void spu_in_mbox_write(netrpc_ctxt_t *ctxt, u64 spu_problem, u32 val);
void spu_in_mbox_write_64(netrpc_ctxt_t *ctxt, u64 spu_problem, u64 val);
void spu_sig_notify_1_2_write_64(netrpc_ctxt_t *ctxt, u64 spu_problem, u64 val);
void spu_isolation_req_enable(netrpc_ctxt_t *ctxt, u64 spu_priv2);
void spu_isolation_req(netrpc_ctxt_t *ctxt, u64 spu_problem);
void spu_stop_req(netrpc_ctxt_t *ctxt, u64 spu_problem);
void spu_runcntl_req(netrpc_ctxt_t *ctxt, u64 spu_problem, u32 req);
u8 spu_mbox_stat_intr_out_mbox_count(netrpc_ctxt_t *ctxt, u64 spu_problem);
u8 spu_mbox_stat_in_mbox_count(netrpc_ctxt_t *ctxt, u64 spu_problem);
u8 spu_mbox_stat_out_mbox_count(netrpc_ctxt_t *ctxt, u64 spu_problem);
u8 spu_mfc_cmd_exec(netrpc_ctxt_t *ctxt, u64 spu_problem, u32 lsa, u64 ea, u16 size, u16 tag, u16 classid, u16 cmd);
u8 spu_mfc_cmd_tag_status(netrpc_ctxt_t *ctxt, u64 spu_problem, u8 tag);

#endif
