#include <stdio.h>

#include "types.h"
#include "netrpc.h"
#include "lv1.h"

#define PS3HOST "192.168.1.2"

int main(int argc, char **argv)
{
	netrpc_ctxt_t ctxt;
	
	//Ohai.
	printf("connecting...");
	if(netrpc_connect(&ctxt, inet_addr(PS3HOST), NETRPC_PORT) < 0)
	{
		printf("error\n");
		return 1;
	}
	printf("ok\n");
	
	printf("ping...");
	if(netrpc_ping(&ctxt) < 0)
	{
		printf("error\n");
		return 1;
	}
	printf("ok\n");
	
	//Call lv1_panic.
	u64 arg_in[] = {1};
	netrpc_hvcall(&ctxt, _N_lv1_panic, arg_in, _ARGCNT(arg_in), NULL, 0);
	
	//Bye.
	netrpc_close(&ctxt);
}
