#include <stdlib.h>

#include "types.h"
#include "netrpc.h"
#include "lv1.h"
#include "util.h"
#include "mm.h"

s64 mm_insert_htab_entry(netrpc_ctxt_t *ctxt, u64 vas_id, u64 va_addr, u64 lpar_addr, u64 page_shift, u64 vflags, u64 rflags, u64 *index)
{
	u64 hpte_group, hpte_v, hpte_r;
	
	hpte_group = (((va_addr >> 28) ^ ((va_addr & 0xFFFFFFFULL) >> page_shift)) & HTAB_HASH_MASK) * HPTES_PER_GROUP;
	
	hpte_v = ((va_addr >> 23) << HPTE_V_AVPN_SHIFT) | HPTE_V_VALID | (vflags & HPTE_V_FLAGS_MASK);
	
	if(page_shift != PAGE_SIZE_4KB)
		hpte_v |= HPTE_V_LARGE;
	
	hpte_r = (lpar_addr & ~((1ULL << page_shift) - 1)) | (rflags & HPTE_R_FLAGS_MASK);
	
	if(page_shift == PAGE_SIZE_1MB)
		hpte_r |= (1 << 12);
	
	u64 insert_args[] = {vas_id, hpte_group, hpte_v, hpte_r, HPTE_V_BOLTED, 0};
	u64 insert_res[] = {0, 0, 0};
	s64 result = netrpc_hvcall(ctxt, _N_lv1_insert_htab_entry, insert_args, 6, insert_res, 3);
	
	if (result != 0)
		return result;
	
	if(index != NULL)
		*index = insert_res[0];
	
	return 0;
}

s64 mm_map_lpar_memory_region(netrpc_ctxt_t *ctxt, u64 vas_id, u64 va_start_addr, u64 lpar_start_addr, u64 size, u64 page_shift, u64 vflags, u64 rflags)
{
	u32 i;
	s64 result;
	
	for(i = 0; i < (size >> page_shift); i++)
	{
		result = mm_insert_htab_entry(ctxt, vas_id, va_start_addr, lpar_start_addr, page_shift, vflags, rflags, 0);
 		if(result != 0)
 			return result;
 		
		va_start_addr += (1 << page_shift);
		lpar_start_addr += (1 << page_shift);
	}
	
	return 0;
}
