#ifndef _LV1_H_
#define _LV1_H_

/*! lv1 result values. */
#define LV1_SUCCESS 0
#define LV1_RESOURCE_SHORTAGE -2
#define LV1_NO_PRIVILEGE -3
#define LV1_DENIED_BY_POLICY -4
#define LV1_ACCESS_VIOLATION -5
#define LV1_NO_ENTRY -6
#define LV1_DUPLICATE_ENTRY -7
#define LV1_TYPE_MISMATCH -8
#define LV1_BUSY -9
#define LV1_EMPTY -10
#define LV1_WRONG_STATE -11
#define LV1_NO_MATCH -13
#define LV1_ALREADY_CONNECTED -14
#define LV1_UNSUPPORTED_PARAMETER_VALUE -15
#define LV1_CONDITION_NOT_SATISFIED -16
#define LV1_ILLEGAL_PARAMETER_VALUE -17
#define LV1_BAD_OPTION -18
#define LV1_IMPLEMENTATION_LIMITATION -19
#define LV1_NOT_IMPLEMENTED -20
#define LV1_INVALID_CLASS_ID -21
#define LV1_CONSTRAINT_NOT_SATISFIED -22
#define LV1_ALIGNMENT_ERROR -23
#define LV1_HARDWARE_ERROR -24
#define LV1_INVALID_DATA_FORMAT -25
#define LV1_INVALID_OPERATION -26
#define LV1_INTERNAL_ERROR -32768

/*! lv1 hvcall numbers. */
#define _N_lv1_allocate_memory								0
#define _N_lv1_write_htab_entry								1
#define _N_lv1_construct_virtual_address_space             	2
#define _N_lv1_invalidate_htab_entries						3
#define _N_lv1_get_virtual_address_space_id_of_ppe			4
#define _N_lv1_query_logical_partition_address_region_info	6
#define _N_lv1_select_virtual_address_space					7
#define _N_lv1_pause										9
#define _N_lv1_destruct_virtual_address_space				10
#define _N_lv1_configure_irq_state_bitmap					11
#define _N_lv1_connect_irq_plug_ext							12
#define _N_lv1_release_memory								13
#define _N_lv1_put_iopte									15
#define _N_lv1_disconnect_irq_plug_ext						17
#define _N_lv1_construct_event_receive_port					18
#define _N_lv1_destruct_event_receive_port					19
#define _N_lv1_send_event_locally							24
#define _N_lv1_detect_pending_interrupts					26
#define _N_lv1_end_of_interrupt								27
#define _N_lv1_connect_irq_plug								28
#define _N_lv1_disconnect_irq_plug							29
#define _N_lv1_end_of_interrupt_ext							30
#define _N_lv1_did_update_interrupt_mask					31
#define _N_lv1_shutdown_logical_partition					44
#define _N_lv1_destruct_logical_spe							54
#define _N_lv1_construct_logical_spe						57
#define _N_lv1_set_spe_interrupt_mask						61
#define _N_lv1_set_spe_transition_notifier					64
#define _N_lv1_disable_logical_spe							65
#define _N_lv1_clear_spe_interrupt_status					66
#define _N_lv1_get_spe_interrupt_status						67
#define _N_lv1_get_logical_ppe_id							69
#define _N_lv1_set_interrupt_mask							73
#define _N_lv1_get_logical_partition_id						74
#define _N_lv1_configure_execution_time_variable			77
#define _N_lv1_get_spe_irq_outlet							78
#define _N_lv1_set_spe_privilege_state_area_1_register		79
#define _N_lv1_create_repository_node						90
#define _N_lv1_read_repository_node							91
#define _N_lv1_modify_repository_node_value					92
#define _N_lv1_remove_repository_node						93
#define _N_lv1_read_htab_entries							95
#define _N_lv1_set_dabr										96
#define _N_lv1_set_vmx_graphics_mode						97
#define _N_lv1_set_thread_switch_control_register			98
#define _N_lv1_get_total_execution_time						103
#define _N_lv1_allocate_io_segment							116
#define _N_lv1_release_io_segment							117
#define _N_lv1_allocate_ioid								118
#define _N_lv1_release_ioid									119
#define _N_lv1_construct_io_irq_outlet						120
#define _N_lv1_destruct_io_irq_outlet						121
#define _N_lv1_map_htab										122
#define _N_lv1_unmap_htab									123
#define _N_lv1_get_version_info								127
#define _N_lv1_construct_lpm								140
#define _N_lv1_destruct_lpm									141
#define _N_lv1_start_lpm									142
#define _N_lv1_stop_lpm										143
#define _N_lv1_copy_lpm_trace_buffer						144
#define _N_lv1_add_lpm_event_bookmark						145
#define _N_lv1_delete_lpm_event_bookmark					146
#define _N_lv1_set_lpm_interrupt_mask						147
#define _N_lv1_get_lpm_interrupt_status						148
#define _N_lv1_set_lpm_general_control						149
#define _N_lv1_set_lpm_interval								150
#define _N_lv1_set_lpm_trigger_control						151
#define _N_lv1_set_lpm_counter_control						152
#define _N_lv1_set_lpm_group_control						153
#define _N_lv1_set_lpm_debug_bus_control					154
#define _N_lv1_set_lpm_counter								155
#define _N_lv1_set_lpm_signal								156
#define _N_lv1_set_lpm_spr_trigger							157
#define _N_lv1_insert_htab_entry							158
#define _N_lv1_read_virtual_uart							162
#define _N_lv1_write_virtual_uart							163
#define _N_lv1_set_virtual_uart_param						164
#define _N_lv1_get_virtual_uart_param						165
#define _N_lv1_configure_virtual_uart_irq					166
#define _N_lv1_open_device									170
#define _N_lv1_close_device									171
#define _N_lv1_map_device_mmio_region						172
#define _N_lv1_unmap_device_mmio_region						173
#define _N_lv1_allocate_device_dma_region					174
#define _N_lv1_free_device_dma_region						175
#define _N_lv1_map_device_dma_region						176
#define _N_lv1_unmap_device_dma_region						177
#define _N_lv1_read_pci_config								178
#define _N_lv1_write_pci_config								179
#define _N_lv1_read_pci_io									180
#define _N_lv1_write_pci_io									181
#define _N_lv1_net_add_multicast_address					185
#define _N_lv1_net_remove_multicast_address					186
#define _N_lv1_net_start_tx_dma								187
#define _N_lv1_net_stop_tx_dma								188
#define _N_lv1_net_start_rx_dma								189
#define _N_lv1_net_stop_rx_dma								190
#define _N_lv1_net_set_interrupt_status_indicator			191
#define _N_lv1_net_set_interrupt_mask						193
#define _N_lv1_net_control									194
#define _N_lv1_connect_interrupt_event_receive_port			197
#define _N_lv1_disconnect_interrupt_event_receive_port		198
#define _N_lv1_get_spe_all_interrupt_statuses				199
#define _N_lv1_deconfigure_virtual_uart_irq					202
#define _N_lv1_enable_logical_spe							207
#define _N_lv1_gpu_open										210
#define _N_lv1_gpu_close									211
#define _N_lv1_gpu_device_map								212
#define _N_lv1_gpu_device_unmap								213
#define _N_lv1_gpu_memory_allocate							214
#define _N_lv1_gpu_memory_free								216
#define _N_lv1_gpu_context_allocate							217
#define _N_lv1_gpu_context_free								218
#define _N_lv1_gpu_context_iomap							221
#define _N_lv1_gpu_context_attribute						225
#define _N_lv1_gpu_context_intr								227
#define _N_lv1_gpu_attribute								228
#define _N_lv1_get_rtc										232
#define _N_lv1_set_ppe_periodic_tracer_frequency			240
#define _N_lv1_start_ppe_periodic_tracer					241
#define _N_lv1_stop_ppe_periodic_tracer						242
#define _N_lv1_storage_read									245
#define _N_lv1_storage_write								246
#define _N_lv1_storage_send_device_command					248
#define _N_lv1_storage_get_async_status						249
#define _N_lv1_storage_check_async_status					254
#define _N_lv1_panic										255

#endif
