#include <stdio.h>

#include "types.h"
#include "netrpc.h"
#include "lv1.h"

#define PS3HOST "192.168.1.2"

#define BUS 4
#define DEV 1

#define LPAR 0x100000
#define LPAR_SIZE 0x100000
#define DBUF (LPAR + 0x10000)

void _close_device(netrpc_ctxt_t *ctxt)
{
	//Close device.
	u64 close_args[] = {BUS, DEV};
	netrpc_hvcall(ctxt, _N_lv1_close_device, close_args, _ARGCNT(close_args), NULL, 0);
}

u64 _wait(netrpc_ctxt_t *ctxt, u32 etag)
{
	u64 status_args[] = {DEV};
	u64 status_res[] = {0 /* tag */, 0 /* status */};
	
	do
	{
		//Get storage status.
		s64 res = netrpc_hvcall(ctxt, _N_lv1_storage_get_async_status, status_args, 1, status_res, 2);
		if(res == 0)
			if(_ES64(status_res[0]) == etag)
				return _ES64(status_res[1]);
	} while(1);
}

int main(int argc, char **argv)
{
	netrpc_ctxt_t ctxt;
	
	//Ohai.
	printf("connecting...");
	if(netrpc_connect(&ctxt, inet_addr(PS3HOST), NETRPC_PORT) < 0)
	{
		printf("error\n");
		return 1;
	}
	printf("ok\n");
	
	printf("ping...");
	if(netrpc_ping(&ctxt) < 0)
	{
		printf("error\n");
		return 1;
	}
	printf("ok\n");
	
	netrpc_clrmmio(&ctxt);
	
	//Close device.
	_close_device(&ctxt);
	
	//Open device.
	u64 open_args[] = {BUS, DEV, 0};
	netrpc_hvcall(&ctxt, _N_lv1_open_device, open_args, 3, NULL, 0);
		
	//Allocate device DMA region.
	u64 alloc_dma_args[] = {BUS, DEV, LPAR_SIZE, 12, 0};
	u64 alloc_dma_res[] = {0 /* busaddr */};
	netrpc_hvcall(&ctxt, _N_lv1_allocate_device_dma_region, alloc_dma_args, 5, alloc_dma_res, 1);
	
	//Map device DMA region.
	u64 map_dma_args[] = {BUS, DEV, LPAR, alloc_dma_res[0], LPAR_SIZE, 0xf800000000000000};
	netrpc_hvcall(&ctxt, _N_lv1_map_device_dma_region, map_dma_args, 6, NULL, 0);
	
	u8 buffer[0x2c00];
	FILE *fp = fopen("flash.bin", "wb");
	u32 sec;
	
	//Save sectors.
	for(sec = 0; sec < 0x8000; sec += 16)
	{
		//Read sector.
		u64 read_args[] = {DEV, 0, sec, 16, 0x02, DBUF};
		u64 read_res[] = {0 /* tag */};
		netrpc_hvcall(&ctxt, _N_lv1_storage_read, read_args, 6, read_res, 1);
		
		if(_wait(&ctxt, read_res[0]) == 0)
		{
			//Copy data in.
			netrpc_memcpy_in(&ctxt, buffer, DBUF, 0x2c00);
			fwrite(buffer, sizeof(u8), 0x2c00, fp);
			
			printf("\rsaved sector 0x%x (%dKiB)", sec, (sec+1)/2);
		}		
	}
	
	printf("\nflash saved\n");
	
	fclose(fp);
	
	//Close device.
	_close_device(&ctxt);
	
	//Bye.
	netrpc_close(&ctxt);
}
