#line 0 "source/patch_shit.c"
/*
 * patch_shit.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */
#include <stdio.h>
#include <inttypes.h>

#include <ppu-lv2.h>
#include <ppu-types.h>

#include "common.h"
#include "debug.h"
#include "patching.h"
#include "patchutil.h"


/*
 * defines
 */
#define ptr2ea(x) ((u64)(void *)(x))
#define ea2va(ea) ((u64)((ea) & ~(1ULL << 63)))


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */
s32
patchShit ()
{
  static s32 ret =  -1 ;

  dbgprintf ( "patching" ) ;

  /* Patching LV1 hypervisor to enable skipping of ACL checks for all storage devices */
  if ( ( ret = patch_lv1_storage_skip_acl_check ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 storage skip ACL check returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }

  /* Patching LV1 hypervisor to allow mapping of HTAB with write protection */
  if ( ( ret = patch_lv1_htab_write ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 htab write protect returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }

  /* Patching LV1 hypervisor to allow creating/modifying/deleting of repo nodes in any LPAR */
/*
  if ( ( ret = patch_lv1_repo_node_lpar ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 repo node returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor to allow setting data access breakpoints in HV state */
/*
  if ( ( ret = patch_lv1_dabr_priv_mask ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 dabr priv mask returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor to allow setting all bits of SPE register MFC_SR1 */
/*
  if ( ( ret = patch_lv1_mfc_sr1_mask ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 mfc sr1 mask returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor to disable integrity check */
/*
  if ( ( ret = patch_lv1_sysmgr_disable_integrity_check ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 sysmgr disable integrity check returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor SM ability mask of GameOS to allow access to all SM services */
/*
  if ( ( ret = patch_lv1_gameos_sysmgr_ability ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 sysmgr ability returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor to enable extracting all package types */
/*
  if ( ( ret = patch_lv1_um_extract_pkg ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 um extract returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor to enable setting product mode by using UM write EPROM */
/*
  if ( ( ret = patch_lv1_um_write_eprom_product_mode ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 um write eprom product mode returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  /* Patching LV1 hypervisor to allow accessing all Indi Info Manager services */
  if ( ( ret = patch_lv1_iimgr_access ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 iimgr access returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }

  /* Patching LV1 hypervisor Dispatcher Manager to allow access to all SS services */
  if ( ( ret = patch_lv1_dispmgr_access ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 dispmgr access returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }

  /* Patching LV1 hypervisor for debug printing */
/*
  if ( ( ret = patch_lv1_debug_print ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 debug print returned: 0x%x (%d)", ret, ret ) ;
    goto error ; 
  }
*/

  ret = 0 ;

  dbgprintf ( "patched" ) ;
  goto done ;

error:
  errprintf ( "%s!", "failure patching" ) ;

done:
  return ( ret ) ;
}

/* Patching LV1 hypervisor to unmask bootldr by HV */
s32
patchUnmaskBootldr ()
{
  s32 ret = -1 ;

  if ( ( ret = patch_lv1_unmask ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 unmask bootldr returned: 0x%x (%d)", ret, ret ) ;
    syscall_lv2_beep ( SYSCALL_BEEP_THRICE ) ;
  }

  return ( ret ) ;
}

/* Patching LV1 hypervisor to mask bootldr by HV */
s32
patchMaskBootldr ()
{
  s32 ret = -1 ;

  if ( ( ret = patch_lv1_mask ( fw_data.fw_version ) ) != 0 )
  {
    errprintf ( "LV1 mask bootldr returned: 0x%x (%d)", ret, ret ) ;
    syscall_lv2_beep ( SYSCALL_BEEP_THRICE ) ;
  }

  return ( ret ) ;
}

