#line 0 "source/menuUtils.c"
/*
 * menuUtils.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "menu.h"


/*
 * functions
 */

/* load images into buffers */
void
menuLoadImages ( menuData *m_data, videoutilData *vu_data )
{
  dbgprintf ( "loading" ) ;

  dbgprintf ( "background images" ) ;
#ifdef PS3D
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_BLACK, (void*)image_board_black_1280_720_png, image_board_black_1280_720_png_size, vu_data ) ;
#endif

#ifndef PS3D
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_BROWN, (void*)image_board_brown_1280_720_png, image_board_brown_1280_720_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_RED,   (void*)image_board_red_1280_720_png,   image_board_red_1280_720_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_GREEN, (void*)image_board_green_1280_720_png, image_board_green_1280_720_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_BLUE,  (void*)image_board_blue_1280_720_png,  image_board_blue_1280_720_png_size, vu_data ) ;
#endif

  dbgprintf ( "menu images" ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_MAIN,  (void*)image_main_1024_512_png,  image_main_1024_512_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_HELP,  (void*)image_help_1024_512_png,  image_help_1024_512_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_ABOUT, (void*)image_about_1024_512_png, image_about_1024_512_png_size, vu_data ) ;

  dbgprintf ( "dumping images" ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_PAGE,  (void*)image_page_1024_16_png,  image_page_1024_16_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_PAGE1, (void*)image_page_1024_16_png,  image_page_1024_16_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_PAGE2, (void*)image_page_1024_16_png,  image_page_1024_16_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_PAGE3, (void*)image_page_1024_16_png,  image_page_1024_16_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_PAGE4, (void*)image_page_1024_16_png,  image_page_1024_16_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_DUMP,  (void*)image_dump_1024_512_png, image_dump_1024_512_png_size, vu_data ) ;

  dbgprintf ( "loaded" ) ;
}

/* unload images from bufers */
void
menuUnloadImages ( menuData *m_data, videoutilData *vu_data )
{
  dbgprintf ( "unloading" ) ;

  videoutilImageFinish ( vu_data ) ;

  dbgprintf ( "unloaded" ) ;
}

/* get pointer to buffer bitmap */
void
menuGetBufferImagePointer ( menuData *m_data, videoutilData *vu_data )
{
  videoutilImageGetPointer ( IMAGE_DUMP, (void**)&m_data->dump_data->buffer_bitmap_ptr, vu_data ) ;

/*
  argprintf ( "got buffer bitmap pointer: %p:%p",
              &m_data->dump_data->buffer_bitmap_ptr,
              m_data->dump_data->buffer_bitmap_ptr ) ;
*/
}

/* get pointer to page bitmap */
void
menuGetPageImagePointer ( menuData *m_data, videoutilData *vu_data )
{
/*
  argprintf ( "getting page bitmap pointers: %p:%p, [0] = %p:%p, [1] = %p:%p",
              &m_data->dump_data->page_bitmap_ptr,
              m_data->dump_data->page_bitmap_ptr,
              &m_data->dump_data->page_bitmap_ptr[0],
              m_data->dump_data->page_bitmap_ptr[0],
              &m_data->dump_data->page_bitmap_ptr[1],
              m_data->dump_data->page_bitmap_ptr[1],
              &m_data->dump_data->page_bitmap_ptr[2],
              m_data->dump_data->page_bitmap_ptr[2],
              &m_data->dump_data->page_bitmap_ptr[3],
              m_data->dump_data->page_bitmap_ptr[3] ) ;
*/

  videoutilImageGetPointer ( IMAGE_PAGE1, (void**)&m_data->dump_data->page_bitmap_ptr[0], vu_data ) ;
  videoutilImageGetPointer ( IMAGE_PAGE2, (void**)&m_data->dump_data->page_bitmap_ptr[1], vu_data ) ;
  videoutilImageGetPointer ( IMAGE_PAGE3, (void**)&m_data->dump_data->page_bitmap_ptr[2], vu_data ) ;
  videoutilImageGetPointer ( IMAGE_PAGE4, (void**)&m_data->dump_data->page_bitmap_ptr[3], vu_data ) ;

/*
  argprintf ( "got page bitmap pointers: %p:%p, [0] = %p:%p, [1] = %p:%p, [2] = %p:%p, [3] = %p:%p",
              &m_data->dump_data->page_bitmap_ptr,
              m_data->dump_data->page_bitmap_ptr,
              &m_data->dump_data->page_bitmap_ptr[0],
              m_data->dump_data->page_bitmap_ptr[0],
              &m_data->dump_data->page_bitmap_ptr[1],
              m_data->dump_data->page_bitmap_ptr[1],
              &m_data->dump_data->page_bitmap_ptr[2],
              m_data->dump_data->page_bitmap_ptr[2],
              &m_data->dump_data->page_bitmap_ptr[3],
              m_data->dump_data->page_bitmap_ptr[3] ) ;
*/
}

/* load tilesets and tiles into buffers */
void
menuLoadTilesets ( menuData *m_data, videoutilData *vu_data )
{
  dbgprintf ( "loading" ) ;

  buttonsInitialization ( m_data->buttons_data ) ;
  digitsInitialization ( m_data->digits_data ) ;

  dbgprintf ( "loaded" ) ;
}

/* unload tilesets from buffers */
void
menuUnloadTilesets ( menuData *m_data, videoutilData *vu_data )
{
  dbgprintf ( "unloading" ) ;

  buttonsFinish ( m_data->buttons_data ) ;
  digitsFinish ( m_data->digits_data ) ;

  dbgprintf ( "unloaded" ) ;
}

/* check menu variable */
inline s32
menuReadMenu ( menuData *m_data )
{
  syncutilRwLockReadLock ( &m_data->rwlock, TIMEOUT ) ;
  s32 ret = *m_data->menu ;
  syncutilRwLockReadUnlock ( &m_data->rwlock ) ;

  return ( ret ) ;
}

/* set menu to render */
inline void
menuWriteMenu ( s32 menu, menuData *m_data )
{
  argprintf ( "menu write: %d", menu ) ;

  syncutilRwLockWriteLock ( &m_data->rwlock, NO_TIMEOUT ) ;
  *m_data->menu = menu ;
  syncutilRwLockWriteUnlock ( &m_data->rwlock ) ;
}

/* increment menu to render */
inline void
menuWriteMenuIncrement ( menuData *m_data )
{
  dbgprintf ( "menu increment" ) ;

  syncutilRwLockWriteLock ( &m_data->rwlock, NO_TIMEOUT ) ;
  *m_data->menu += 1 ;
  syncutilRwLockWriteUnlock ( &m_data->rwlock ) ;
}

/* decrement menu to render */
inline void
menuWriteMenuDecrement ( menuData *m_data )
{
  dbgprintf ( "menu decrement" ) ;

  syncutilRwLockWriteLock ( &m_data->rwlock, NO_TIMEOUT ) ;
  *m_data->menu -= 1 ;
  syncutilRwLockWriteUnlock ( &m_data->rwlock ) ;
}

/* set action */
inline void
menuWriteAction ( s32 action, menuData *m_data )
{
  argprintf ( "action write: %d", action ) ;

  syncutilRwLockWriteLock ( &m_data->rwlock, NO_TIMEOUT ) ;
  *m_data->action = action ;
  syncutilRwLockWriteUnlock ( &m_data->rwlock ) ;
}

/* set focus */
inline void
menuWriteFocus ( s32 focus, menuData *m_data )
{
  argprintf ( "focus write: %d", focus ) ;

  syncutilRwLockWriteLock ( &m_data->rwlock, NO_TIMEOUT ) ;
  *m_data->focus = focus ;
  syncutilRwLockWriteUnlock ( &m_data->rwlock ) ;
}

inline s32
menuReadExitapp ( eventData *e_data )
{
  syncutilRwLockReadLock ( &e_data->rwlock, TIMEOUT ) ;
  s32 ret = e_data->exitapp ;
  syncutilRwLockReadUnlock ( &e_data->rwlock ) ;

  return ( ret ) ;
}

inline void
menuWriteExitapp ( eventData *e_data )
{
  dbgprintf ( "exit toggle" ) ;

  syncutilRwLockWriteLock ( &e_data->rwlock, NO_TIMEOUT ) ;
  e_data->exitapp = 0 ;
  syncutilRwLockWriteUnlock ( &e_data->rwlock ) ;
}

inline void
menuSendDump ( menuData *m_data, s32 dump )
{
  argprintf ( "sending dump: %d", dump ) ;

  if ( *m_data->dmp_port > 0 )
  {
    eventutilSendPort ( m_data->dmp_port, dump, 0, 0 ) ;
  }
}

/* get random u32 value */
inline u32
menuGetRandomSeed ()
{
  u32 seed = 0 ;
  lv2syscall3 ( 865, 2, (u64)&seed, sizeof ( u32 ) ) ;
  return ( seed ) ;
}

/* get random value 1 - size */
inline u8
menuGetRandom ( u8 size )
{
  u32 random = 0 ;

  //lv2syscall3 ( 865, 2, (u64)&random, sizeof ( u32 ) ) ;
  random = ( rand() % size + 1 ) ;

  if ( random < 1 )
  {
    random = 1 ;
  }
  else if ( random > size )
  {
    random = size ;
  }

  return ( (u8)random ) ;
}

