#line 0 "source/menuUpdate.c"
/*
 * menuUpdate.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "menu.h"


/*
 * functions
 */

/* draw center buffer image into main buffer */
inline void
menuUpdateImages ( menuData *m_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  menuDrawImages ( m_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw center buffer image into main buffer */
inline void
menuUpdateDumpBufferImages ( menuData *m_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  menuDrawImageDumpBuffer ( m_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* update 7 segment LED display */
inline void
menuUpdateSevenSegment ( menuData *m_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  menuDrawSevenSegment ( m_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* update buttons */
inline void
menuUpdateButtons ( menuData *m_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  if ( m_data->buttons > 0 )
  {
    menuDrawButtons ( m_data, vu_data ) ;
  }
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

