#line 0 "source/menuReceive.c"
/*
 * menuReceive.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "menu.h"


/*
 * functions
 */

/* receive pad io via event queue */
inline s32
menuReceivePadInput ( menuData *m_data )
{
  s32 ret = 0 ;

  eventutilReceiveEventQueue ( m_data->pad_queue, m_data->pad_event, NO_TIMEOUT ) ;

  if ( m_data->pad_event->data_1 > 0 )
  {
    ret = m_data->pad_event->data_1 ;
  }
  else if ( m_data->pad_event->data_1 == MENU_EXIT && m_data->pad_event->data_2 == MENU_EXIT && m_data->pad_event->data_3 == MENU_EXIT )
  {
    ret = MENU_EXIT ;
  }

  //argprintf ( "read queue: %x, source: %016"PRIx64", update: %016"PRIx64":%016"PRIx64":%016"PRIx64, *m_data->pad_queue, m_data->pad_event->source, m_data->pad_event->data_1, m_data->pad_event->data_2, m_data->pad_event->data_3 ) ;

  return ( ret ) ;
}

/* receive pad io via event queue */
inline s32
menuReceivePadUpdate ( menuData *m_data )
{
  s32 ret = 0 ;
  s32 received = 0 ;

  eventutilTryReceiveEventQueue ( m_data->pad_queue, m_data->pad_event, 1, &received ) ;

  if ( received > 0 && m_data->pad_event->data_1 > 0 )
  {
    ret = m_data->pad_event->data_1 ;
  }

  return ( ret ) ;
}

