#line 0 "source/menuDraw.c"
/*
 * menuDraw.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "menu.h"


/*
 * defines
 */

#define RANDOM(size) menuGetRandom ( size )
#define RANDOM3() RANDOM( 3 )
#define RANDOM4() RANDOM( 4 )

//#define PS3D 1

/*
 * functions
 */

/* draw menu into buffer */
void
menuDraw ( menuData *m_data )
{
  s32 menu = menuReadMenu ( m_data ) ;

  //argprintf ( "menu = %d", menu ) ;

  switch ( menu )
  {
    case 0:
      menuDrawBackground ( m_data ) ;
      menuWriteMenuIncrement ( m_data ) ;
    case MENU_MAIN:
      menuDrawMain ( m_data ) ;
      break ;
    case MENU_HELP:
      menuDrawHelp ( m_data ) ;
      break ;
    case MENU_ABOUT:
      menuDrawAbout ( m_data ) ;
      break ;
    case MENU_DUMP:
      menuDrawDumping ( m_data ) ;
      break ;
    case MENU_DONE:
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    default:
      menuWriteMenuDecrement ( m_data ) ;
      break ;
  }
}

/* draw menu into buffer */
void
menuDrawBackground ( menuData *m_data )
{
  dbgprintf( "drawing" );

  /* clear the buffer */
  menuDrawClearBuffer ( m_data, m_data->vu_data ) ;

  /* draw background image into buffer */
  menuDrawImageBackground ( m_data, m_data->vu_data ) ;

  /* draw 7 segment LED */
  menuDrawSevenSegment ( m_data, m_data->vu_data ) ;

  dbgprintf( "drawn" );
}

/* draw menu into buffer */
void
menuDrawMain ( menuData *m_data )
{
  dbgprintf( "drawing" );

  /* draw background image into buffer */
  menuDrawImageMainBuffer ( m_data, m_data->vu_data ) ;

  dbgprintf( "drawn" );
}

/* draw menu into buffer */
void
menuDrawHelp ( menuData *m_data )
{
  dbgprintf( "drawing" );

  /* draw background image into buffer */
  menuDrawImageHelpBuffer ( m_data, m_data->vu_data ) ;

  dbgprintf( "drawn" );
}

/* draw menu into buffer */
void
menuDrawAbout ( menuData *m_data )
{
  dbgprintf( "drawing" );

  /* draw background image into buffer */
  menuDrawImageAboutBuffer ( m_data, m_data->vu_data ) ;

  dbgprintf( "drawn" );
}

/* draw menu into buffer */
void
menuDrawDumping ( menuData *m_data )
{
  dbgprintf( "drawing" );

  /* draw background image into buffer */
  menuDrawImageDumpBuffer ( m_data, m_data->vu_data ) ;

  dbgprintf( "drawn" );
}

/* clear the buffer */
void
menuDrawClearBuffer ( menuData *m_data, videoutilData *vu_data )
{
  dbgprintf( "clearing" );

  //argprintf ( "vu_data = %p, resc_data = %p, resc_buffer = %p", vu_data, vu_data->resc_data, vu_data->resc_buffer ) ;

  videoutilBufferClear ( vu_data ) ;

  dbgprintf( "cleared" );
}

/* draw background image into buffer */
void
menuDrawImages ( menuData *m_data, videoutilData *vu_data )
{
  dbgprintf( "drawing images" );

  //TIMING_START() ;
  menuDrawImageBackground ( m_data, vu_data ) ;
  menuDrawImageDumpBuffer ( m_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;

  dbgprintf( "drew images" );
}

/* draw 7 segment LED display */
void
menuDrawSevenSegment ( menuData *m_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  menuDrawDigit1 ( DIGIT_ZERO, DIGIT_OFF, m_data, vu_data ) ;
  menuDrawDigit2 ( DIGIT_ZERO, DIGIT_DOTON, m_data, vu_data ) ;
  menuDrawDigit3 ( DIGIT_ZERO, DIGIT_NODOT, m_data, vu_data ) ;
  menuDrawDigit4 ( DIGIT_ONE, DIGIT_NODOT, m_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw buttons */
void
menuDrawButtons ( menuData *m_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  menuDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, m_data, vu_data ) ;
  m_data->buttons = 0 ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw background image */
void
menuDrawImageBackground ( menuData *m_data, videoutilData *vu_data )
{
#ifdef PS3D
  menuDrawImage ( IMAGE_FRAME_BLACK, 0, 0, 0, m_data, vu_data ) ;
#endif

#ifndef PS3D
  menuDrawImage ( RANDOM4(), 0, 0, 0, m_data, vu_data ) ;
#endif
}

/* draw main buffer image */
void
menuDrawImageMainBuffer ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawImage ( IMAGE_MAIN, 0, 128, 135, m_data, vu_data ) ;
}

/* draw help buffer image */
void
menuDrawImageHelpBuffer ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawImage ( IMAGE_HELP, 0, 128, 135, m_data, vu_data ) ;
}

/* draw about buffer image */
void
menuDrawImageAboutBuffer ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawImage ( IMAGE_ABOUT, 0, 128, 135, m_data, vu_data ) ;
}

/* draw dump buffer image */
void
menuDrawImageDumpBuffer ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawImage ( IMAGE_DUMP, 0, 128, 135, m_data, vu_data ) ;
}

/* △  */
/* draw triangle button */
void
menuDrawButtonTriangle ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawButton ( BUTTON_TRIANGLE, BUTTON_DOWN, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, m_data, vu_data ) ;
}

/* ◯  */
/* draw circle button */
void
menuDrawButtonCircle ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CIRCLE, BUTTON_DOWN, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, m_data, vu_data ) ;
}

/* ✕  */
/* draw cross button */
void
menuDrawButtonCross ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CROSS, BUTTON_DOWN, BUTTON_CROSS_X, BUTTON_CROSS_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, m_data, vu_data ) ;
}

/* ☐  */
/* draw square button */
void
menuDrawButtonSquare ( menuData *m_data, videoutilData *vu_data )
{
  menuDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, m_data, vu_data ) ;
  menuDrawButton ( BUTTON_SQUARE, BUTTON_DOWN, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, m_data, vu_data ) ;
}

/* draw digit 1 */
void
menuDrawDigit1 ( u8 number, u8 state, menuData *m_data, videoutilData *vu_data )
{
  menuDrawDigit ( number, state, DIGIT_7SEG1_X, DIGIT_7SEG1_Y, m_data, vu_data ) ;
}

/* draw digit 2 */
void
menuDrawDigit2 ( u8 number, u8 state, menuData *m_data, videoutilData *vu_data )
{
  menuDrawDigit ( number, state, DIGIT_7SEG2_X, DIGIT_7SEG2_Y, m_data, vu_data ) ;
}

/* draw digit 3 */
void
menuDrawDigit3 ( u8 number, u8 state, menuData *m_data, videoutilData *vu_data )
{
  menuDrawDigit ( number, state, DIGIT_7SEG3_X, DIGIT_7SEG3_Y, m_data, vu_data ) ;
}

/* draw digit 4 */
void
menuDrawDigit4 ( u8 number, u8 state, menuData *m_data, videoutilData *vu_data )
{
  menuDrawDigit ( number, state, DIGIT_7SEG4_X, DIGIT_7SEG4_Y, m_data, vu_data ) ;
}

/* image */
void
menuDrawImage ( u8 index, u8 from, s32 x, s32 y, menuData *m_data, videoutilData *vu_data )
{
  videoutilImageBufferDrawBlend ( index, from, x, y, vu_data ) ;
}

/* button */
void
menuDrawButton ( u8 object, u8 state, s32 x, s32 y, menuData *m_data, videoutilData *vu_data )
{
  vu_data->tileset_data = m_data->buttons_data ;

  buttonDraw ( object, state, 0, x, y, vu_data ) ;

  m_data->buttons = object ;
}

/* digit */
void
menuDrawDigit ( u8 object, u8 state, s32 x, s32 y, menuData *m_data, videoutilData *vu_data )
{
  vu_data->tileset_data = m_data->digits_data ;

  digitDraw ( object, state, 0, x, y, vu_data ) ;
}

/* draw header text into buffer */
void
menuDrawHeaderText ( u8 idx, s32 *x, s32 *y, menuData *m_data, videoutilData *vu_data )
{
  sprintf ( m_data->string, "::[%s %s]::", MEMDUMP_TITLE, MEMDUMP_VERSION ) ;
  argprintf( "%s", m_data->string );

  //videoutilFontBufferPrint ( idx, *x, *y, m_data->string, vu_data ) ;
}

/* firmware version information */
void
menuDrawFirmwareVersion ( u8 idx, s32 *x, s32 *y, menuData *m_data, videoutilData *vu_data )
{
  *y += LINE_SIZE ;

  sprintf ( m_data->string, ": Firmware Version: " ) ;
  argprintf( "%s", m_data->string );

  //videoutilFontBufferPrint ( idx, *x+ 20, *y, m_data->string, vu_data ) ;

  sprintf ( m_data->string, "%d.%d (0x%x) :: spoof: %d", fw_data.fw_major, fw_data.fw_minor, fw_data.fw_version, fw_data.spoof ) ;
  argprintf( "%s", m_data->string );

  //videoutilFontBufferPrint ( 0, *x + 300, *y, m_data->string, vu_data ) ;
}

