#line 0 "source/menuCheck.c"
/*
 * menuCheck.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "menu.h"


/*
 * functions
 */

/* check if menu needs to be redrawn */
void
menuCheckUpdate ( menuData *m_data )
{
  menuCheckInput ( m_data ) ;
}

/* check controller */
void
menuCheckInput ( menuData *m_data )
{
  s32 menu = -1 ;

  if ( ( menu = menuReadMenu ( m_data ) ) < 0 )
  {
    menu = MENU_DONE ;
  }
  else if ( menu > MENU_DONE )
  {
    menu = MENU_MAIN ;
  }

  switch ( menu )
  {
    case 0:
      menuWriteMenuIncrement ( m_data ) ;
    case MENU_MAIN:
      menuCheckMain ( m_data ) ;
      break ;
    case MENU_HELP:
      menuCheckHelp ( m_data ) ;
      break ;
    case MENU_ABOUT:
      menuCheckAbout ( m_data ) ;
      break ;
    case MENU_DUMP:
      menuCheckDumping ( m_data ) ;
      break ;
    case MENU_DONE:
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    default:
      menuWriteMenuDecrement ( m_data ) ;
      break ;
  }
}

/* check controller buttons */
s32
menuCheckMain ( menuData *m_data )
{
  s32 ret = -1 ;

  ret = menuReceivePadInput ( m_data ) ;

  switch ( ret )
  {
    case 0:
      menuUpdateButtons ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_TRIANGLE:
      dbgprintf ( "MENU_TRIANGLE" ) ;
      menuDrawButtonTriangle ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_LV1 ) ;
      break ;
    case MENU_CIRCLE:
      dbgprintf ( "MENU_CIRCLE" ) ;
      menuDrawButtonCircle ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_LV2 ) ;
      break ;
    case MENU_CROSS:
      dbgprintf ( "MENU_CROSS" ) ;
      menuDrawButtonCross ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_FLASH ) ;
      break ;
    case MENU_SQUARE:
      dbgprintf ( "MENU_SQUARE" ) ;
      menuDrawButtonSquare ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_eEID ) ;
      break ;
    case MENU_SELECT:
      dbgprintf ( "MENU_SELECT" ) ;
      menuWriteMenu ( MENU_HELP, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_UP:
      dbgprintf ( "MENU_UP" ) ;
      menuWriteMenu ( MENU_ABOUT, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_RIGHT:
      dbgprintf ( "MENU_RIGHT" ) ;
      menuWriteMenu ( MENU_HELP, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_DOWN:
      dbgprintf ( "MENU_DOWN" ) ;
      menuWriteMenu ( MENU_HELP, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_LEFT:
      dbgprintf ( "MENU_LEFT" ) ;
      menuWriteMenu ( MENU_ABOUT, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_START:
      dbgprintf ( "MENU_START" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    case MENU_EXIT:
      dbgprintf ( "MENU_EXIT" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    default:
      argprintf ( "default: %d", ret ) ;
      break ;
  }

  return 0 ;
}

/* check controller buttons */
s32
menuCheckHelp ( menuData *m_data )
{
  s32 ret = -1 ;

  ret = menuReceivePadInput ( m_data ) ;

  switch ( ret )
  {
    case 0:
      menuUpdateButtons ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_TRIANGLE:
      dbgprintf ( "MENU_TRIANGLE" ) ;
      menuDrawButtonTriangle ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_LV1 ) ;
      break ;
    case MENU_CIRCLE:
      dbgprintf ( "MENU_CIRCLE" ) ;
      menuDrawButtonCircle ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_LV2 ) ;
      break ;
    case MENU_CROSS:
      dbgprintf ( "MENU_CROSS" ) ;
      menuDrawButtonCross ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_FLASH ) ;
      break ;
    case MENU_SQUARE:
      dbgprintf ( "MENU_SQUARE" ) ;
      menuDrawButtonSquare ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_eEID ) ;
      break ;
    case MENU_SELECT:
      dbgprintf ( "MENU_SELECT" ) ;
      menuWriteMenu ( MENU_ABOUT, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_UP:
      dbgprintf ( "MENU_UP" ) ;
      menuWriteMenu ( MENU_MAIN, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_RIGHT:
      dbgprintf ( "MENU_RIGHT" ) ;
      menuWriteMenu ( MENU_ABOUT, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_DOWN:
      dbgprintf ( "MENU_DOWN" ) ;
      menuWriteMenu ( MENU_ABOUT, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_LEFT:
      dbgprintf ( "MENU_LEFT" ) ;
      menuWriteMenu ( MENU_MAIN, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_START:
      dbgprintf ( "MENU_START" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    case MENU_EXIT:
      dbgprintf ( "MENU_EXIT" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    default:
      argprintf ( "default: %d", ret ) ;
      break ;
  }

  return ( 0 ) ;
}

/* check controller buttons */
s32
menuCheckAbout ( menuData *m_data )
{
  s32 ret = -1 ;

  ret = menuReceivePadInput ( m_data ) ;

  switch ( ret )
  {
    case 0:
      menuUpdateButtons ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_TRIANGLE:
      dbgprintf ( "MENU_TRIANGLE" ) ;
      menuDrawButtonTriangle ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_LV1 ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_CIRCLE:
      dbgprintf ( "MENU_CIRCLE" ) ;
      menuDrawButtonCircle ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_LV2 ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_CROSS:
      dbgprintf ( "MENU_CROSS" ) ;
      menuDrawButtonCross ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_FLASH ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_SQUARE:
      dbgprintf ( "MENU_SQUARE" ) ;
      menuDrawButtonSquare ( m_data, m_data->vu_data ) ;
      menuSendDump ( m_data, DUMP_eEID ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_SELECT:
      dbgprintf ( "MENU_SELECT" ) ;
      menuWriteMenu ( MENU_MAIN, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_UP:
      dbgprintf ( "MENU_UP" ) ;
      menuWriteMenu ( MENU_HELP, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_RIGHT:
      dbgprintf ( "MENU_RIGHT" ) ;
      menuWriteMenu ( MENU_MAIN, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_DOWN:
      dbgprintf ( "MENU_DOWN" ) ;
      menuWriteMenu ( MENU_MAIN, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_LEFT:
      dbgprintf ( "MENU_LEFT" ) ;
      menuWriteMenu ( MENU_HELP, m_data ) ;
      menuDraw ( m_data ) ;
      break ;
    case MENU_START:
      dbgprintf ( "MENU_START" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    case MENU_EXIT:
      dbgprintf ( "MENU_EXIT" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    default:
      argprintf ( "default: %d", ret ) ;
      break ;
  }

  return ( 0 ) ;
}

/* check controller buttons */
s32
menuCheckDumping ( menuData *m_data )
{
  s32 ret = -1 ;

  ret = menuReceivePadInput ( m_data ) ;

  switch ( ret )
  {
    case 0:
      menuUpdateButtons ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_TRIANGLE:
      dbgprintf ( "MENU_TRIANGLE" ) ;
      menuDrawButtonTriangle ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_CIRCLE:
      dbgprintf ( "MENU_CIRCLE" ) ;
      menuDrawButtonCircle ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_CROSS:
      dbgprintf ( "MENU_CROSS" ) ;
      menuDrawButtonCross ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_SQUARE:
      dbgprintf ( "MENU_SQUARE" ) ;
      menuDrawButtonSquare ( m_data, m_data->vu_data ) ;
      break ;
    case MENU_SELECT:
      dbgprintf ( "MENU_SELECT" ) ;
      break ;
    case MENU_LEFT:
      dbgprintf ( "MENU_LEFT" ) ;
      break ;
    case MENU_UP:
      dbgprintf ( "MENU_UP" ) ;
      break ;
    case MENU_RIGHT:
      dbgprintf ( "MENU_RIGHT" ) ;
      break ;
    case MENU_DOWN:
      dbgprintf ( "MENU_DOWN" ) ;
      break ;
    case MENU_START:
      dbgprintf ( "MENU_START" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    case MENU_EXIT:
      dbgprintf ( "MENU_EXIT" ) ;
      menuDrawClearBuffer ( m_data, m_data->vu_data ) ;
      menuWriteExitapp ( m_data->e_data ) ;
      break ;
    default:
      argprintf ( "default: %d", ret ) ;
      break ;
  }

  return ( 0 ) ;
}

