#line 0 "source/menu.c"
/*
 * menu.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "menu.h"
#include "images.h"


/*
 * functions
 */

/* initialize menu */
void
menuInitialization ( menuData *m_data, eventData *e_data, dumpData *d_data, videoutilData *vu_data, u64 *priority )
{
  dbgprintf( "initializing" );

  *m_data->menu = 0 ;
  *m_data->update = 0 ;
  *m_data->line = 0 ;
  *m_data->indent = LINE_INDENT ;

  m_data->string = NULL ;

  m_data->e_data = e_data ;
  m_data->exitapp = &e_data->exitapp ;

  m_data->dump_data = d_data ;

  m_data->vu_data = vu_data ;

  dbgprintf( "sync stuff" );

  /* initialize mutex attributes */
  m_data->mutex_attr.key = MENU_KEY ;
  m_data->mutex_attr.attr_protocol = SYS_MUTEX_PROTOCOL_FIFO ;
  m_data->mutex_attr.attr_pshared = SYS_MUTEX_ATTR_PSHARED ;
  m_data->mutex_attr.attr_recursive = SYS_MUTEX_ATTR_RECURSIVE ;
  m_data->mutex_attr.attr_adaptive = SYS_MUTEX_ATTR_ADAPTIVE ;

  /* initialize reader/writer attributes */
  m_data->rwlock_attr.key = MENU_KEY ;
  m_data->rwlock_attr.attr_protocol = SYS_RWLOCK_PROTOCOL_FIFO ;
  m_data->rwlock_attr.attr_pshared = SYS_RWLOCK_ATTR_PSHARED ;
  m_data->rwlock_attr.flags = 0 ;

  /* initialize condition attributes */
  m_data->cond_attr.key = MENU_KEY ;
  m_data->cond_attr.attr_pshared = SYS_COND_ATTR_PSHARED ;

  /* initialize key */
  m_data->key = SYS_EVENT_QUEUE_KEY_LOCAL ;

  dbgprintf( "event stuff" );

  /* pad events */
  m_data->pad_event = &e_data->pad_event ;
  m_data->pad_queue = &e_data->pad_queue ;
  m_data->pad_queue_attr = &e_data->pad_queue_attr ;
  m_data->pad_port = &e_data->pad_port ;

  /* video events */
  m_data->vid_event = &e_data->vid_event ;
  m_data->vid_queue = &e_data->vid_queue ;
  m_data->vid_queue_attr = &e_data->vid_queue_attr ;
  m_data->vid_port = &e_data->vid_port ;

  /* menu events */
  m_data->mnu_event = &e_data->mnu_event ;
  m_data->mnu_queue = &e_data->mnu_queue ;
  m_data->mnu_queue_attr = &e_data->mnu_queue_attr ;
  m_data->mnu_port = &e_data->mnu_port ;

  /* dump events */
  m_data->dmp_event = &e_data->dmp_event ;
  m_data->dmp_queue = &e_data->dmp_queue ;
  m_data->dmp_queue_attr = &e_data->dmp_queue_attr ;
  m_data->dmp_port = &e_data->dmp_port ;

  dbgprintf( "create sync stuff" );

  /* create mutex */
  syncutilMutexCreate ( &m_data->mutex, &m_data->mutex_attr ) ;

  /* create reader/writer lock */
  syncutilRwLockCreate ( &m_data->rwlock, &m_data->rwlock_attr ) ;

  /* create cond */
  syncutilCondCreate ( &m_data->cond, &m_data->mutex, &m_data->cond_attr ) ;

  /* start menu thread */
  dbgprintf( "thread spawn" );
  menuThread ( m_data, priority ) ;

  dbgprintf( "initialized" );
}

/* release menu resources */
void
menuFinish ( menuData *m_data )
{
  dbgprintf( "finishing" );

  /* free string */
  free ( m_data->string ) ;

  /* free tilesets */
  //menuUnloadTilesets ( m_data, m_data->vu_data ) ;

  /* free images */
  //menuUnloadImages ( m_data, m_data->vu_data ) ;

  /* destroy rwlock */
  syncutilRwLockDestroy ( &m_data->rwlock ) ;

  /* destroy cond */
  syncutilCondDestroy ( &m_data->cond ) ;

  /* destroy mutex */
  syncutilMutexDestroy ( &m_data->mutex ) ;

  dbgprintf( "finished" );
}

/* menu thread */
void
menuThread ( menuData *m_data, u64 *priority )
{
  argprintf( "starting :: priority: %016"PRIx64, *priority );

  /* lock menu mutex */
  syncutilMutexLock ( &m_data->mutex, TIMEOUT ) ;

  /* create menu thread */
  dbgprintf( "thread create" );
  sysThreadCreate ( &m_data->ppu_thread, menuWorker, ( void * ) m_data,
                    *priority += 10, ( size_t ) 0x100000, 0,
                    "menuWorker" ) ;

  /* wait for menu thread to be ready */
  dbgprintf( "thread waiting" );
  syncutilCondWait ( &m_data->cond, NO_TIMEOUT ) ;

  /* release lock */
  syncutilMutexUnlock ( &m_data->mutex ) ;

  dbgprintf( "started" );
}

/* menu worker */
void
menuWorker ( void *arg )
{
  dbgprintf( "starting" );

  /* cast the void *arg to menuData */
  menuData* m_data = ( menuData* ) arg ;

  /* prime pseudo-random generator */
  u32 seed = menuGetRandomSeed() ;
  srand ( seed ) ;

  /* allocate memory for string */
  dbgprintf( "malloc" );
  m_data->string = malloc ( MAX_STRING ) ;
  memset ( m_data->string, 0, MAX_STRING ) ;

  /* aio data */
  aioData aio_data;
  m_data->aio_data = &aio_data ;
  m_data->dump_data->aio_data = &aio_data ;

  /* buttons data */
  buttonsData btn_data ;
  btn_data.tileset_buffer = m_data->vu_data->tileset_buffer ;
  m_data->buttons_data = &btn_data ;
  m_data->buttons_buffer = m_data->vu_data->tileset_buffer ;

  /* digits data */
  digitsData dgt_data ;
  dgt_data.tileset_buffer = m_data->vu_data->tileset_buffer ;
  m_data->digits_data = &dgt_data ;
  m_data->digits_buffer = m_data->vu_data->tileset_buffer ;

  /* load images into RSX buffers */
  menuLoadImages ( m_data, m_data->vu_data ) ;

  /* load tilesets into buffers */
  menuLoadTilesets ( m_data, m_data->vu_data ) ;

  /* load bitmap font into buffers */
/*
  menuLoadBitmapFont ( m_data, m_data->vu_data ) ;
*/

  dbgprintf( "signalling" );

  /* signal main thread is ready */
  syncutilCondSignal ( &m_data->cond ) ;

  /* lock mutex */
  syncutilMutexLock ( &m_data->mutex, TIMEOUT ) ;

  dbgprintf( "waiting" );

  /* wait for main to be ready */
  syncutilCondWait ( &m_data->cond, NO_TIMEOUT ) ;

  /* release lock */
  syncutilMutexUnlock ( &m_data->mutex ) ;

  /* image pointers */
  menuGetBufferImagePointer ( m_data, m_data->vu_data ) ;
  menuGetPageImagePointer ( m_data, m_data->vu_data ) ;

  /* draw menu */
  menuDraw ( m_data ) ;

  dbgprintf( "entering loop" );

  /* render frames until exit */
  while ( *m_data->exitapp )
  {
    /* check menu update */
    menuCheckUpdate ( m_data ) ;
  }

  dbgprintf( "left loop" );

  /* finish */
  menuFinish ( m_data ) ;

  dbgprintf( "thread exiting" );

  /* exit thread */
  sysThreadExit ( 0 ) ;
}

