#line 0 "source/map_memory.c"
/*
 * map_memory.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>
#include <time.h>

#include <ppu_intrinsics.h>

#include <sys/time.h>

#include "common.h"
#include "debug.h"
#include "patchutil.h"


/*
 * defines
 */

#define VAS_ID             0


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

s32
map_memory ( u64 offset, u64 size, u64 *mmap_lpar_addr, u64 base )
{
  s32 ret = 0 ;

  /* lv1_undocumented_function_114 ( u64 start, u64 page_shift, u64 size, u64 *lpar_addr ) */
  if ( ( ret = hvcall_lv1_undocumented_function_114 ( offset, SYSCALL_HV_PAGE_SHIFT, SYSCALL_HV_PAGE_SIZE, mmap_lpar_addr ) ) != 0 )
  {
    errprintf ( "ERROR: hvcall_lv1_undocumented_function_114 returned: 0x%x", ret ) ;
    return ( ret ) ;
  }

  /* mm_map_lpar_memory_region ( u64 lpar_start_addr, u64 ea_start_addr, u64 size, u64 page_shift, u64 prot ) */
  if ( ( ret = hvcall_mm_map_lpar_memory_region ( VAS_ID, SYSCALL_HV_BASE, *mmap_lpar_addr, SYSCALL_HV_PAGE_SIZE, SYSCALL_HV_PAGE_SHIFT, 0, 0 ) ) != 0 )
  {
    errprintf( "ERROR: hvcall_mm_map_lpar_memory_region returned: 0x%x", ret );
    return ( ret ) ;
  }

  return ( 0 ) ;
}

void
unmap_memory ( u64 *mmap_lpar_addr )
{
  if ( *mmap_lpar_addr != 0 )
  {
    hvcall_lv1_undocumented_function_115 ( *mmap_lpar_addr ) ;
    *mmap_lpar_addr = 0ULL ;
  }
}

