#line 0 "source/main.c"
/*
 * main.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <inttypes.h>

#include <ppu-lv2.h>
#include <ppu-types.h>

#include <sys/mutex.h>
#include <sys/cond.h>
#include <sys/thread.h>
#include <sys/process.h>

#include "common.h"
#include "debug.h"
#include "menu.h"
#include "modules.h"
#include "patching.h"
#include "dumping.h"
#include "images.h"

#include "file.h"
#include "hexdump.h"
#include "patchutil.h"
#include "sysmoduleutil.h"
#include "syncutil.h"
#include "eventutil.h"
#include "padutil.h"
#include "videoutil.h"


/*
 * defines
 */
#define ptr2ea(x) ((u64)(void *)(x))
#define ea2va(ea) ((u64)((ea) & ~(1ULL << 63)))


/*
 * globals
 */

extern fwVersions fw_data ;
u32 log_fd = 0 ;
char string[MAX_STRING] = { 0 } ;

extern s32 sysGetSystemSwVersion () ;

/* set initial stack size */
SYS_PROCESS_PARAM( 1001, 0x100000 ) ;


/*
 * functions
 */
s32
main ( s32 argc, const char *argv[] )
{
  static s32 ret = -1 ;
  s32 fw_version = 0, menu = 1, update, action = 0, focus = 0, patched = 0, dumped = 0, line, indent ;

  /* thread variables */
  u64 priority = 1500 ;

  /* data structs */
  eventData evt_data ;
  videoutilData vu_data ;
  menuData mnu_data ;
  imagesData img_data ;
  dumpData dmp_data ;
  patchData patch_data ;

  char *path_ptr = NULL ;
  char *filename_ptr = NULL ;
  s32 filename_len = 0 ;

  /* register modulesUnload for execution at type exit */
  if ( ( ret = atexit ( modulesUnload ) ) != 0 )
  {
    write_tty ( "ERROR: cannot set atexit function" ) ;
    exit ( EXIT_FAILURE ) ;
  }

  /* load sysmodule sprx' */
  modulesLoad () ;

  /* log file */
  if ( ( path_ptr = malloc ( MAX_STRING ) ) == NULL )
  {
    write_tty ( "ERROR: malloc mount point " ) ;
    goto exit ;
  }

  if ( ( filename_ptr = malloc ( MAX_STRING ) ) == NULL )
  {
    write_tty ( "ERROR: malloc path" ) ;
    goto exit ;
  }

  if ( ( ret = fileMountpoint ( STORE_USB, path_ptr ) ) != 0 )
  {
    write_tty ( "ERROR: mount point could not be determined" ) ;
    goto exit ;
  }

  /* get firmware version for log filename */
  fw_version = sysGetSystemSwVersion () ;

  /* assemble log file path and filename */
  filename_len = ( strlen ( path_ptr ) + 2 + strlen ( LOG_NAME ) + 7 + strlen ( LOG_EXTENSION ) + 1 ) ;
  snprintf ( filename_ptr, filename_len, "%s/%s_%d.%s", path_ptr, LOG_NAME, fw_version, LOG_EXTENSION ) ;

  sysFsChmod ( filename_ptr, 0170777 ) ;
  sysFsUnlink ( filename_ptr ) ;

  /* open log file */
  if ( ( ret = open_log ( filename_ptr, &log_fd ) ) < 0 )
  {
    write_tty ( "ERROR: log open failed!\n" ) ;
    goto exit ;
  }

  if ( log_fd == 0 )
  {
    write_tty ( "ERROR: log open failed!" ) ;
    goto exit ;
  }

  argprintf ( "writing log file %s", filename_ptr ) ;

  /* log file header */
  dbgprintf ( "+===========================+" ) ;
  dbgprintf ( "|                           |" ) ;
  dbgprintf ( "|          memdump          |" ) ;
#ifdef PS3D
  dbgprintf ( "|   #ps3d private edition   |" ) ;
#endif
  dbgprintf ( "|                           |" ) ;
  dbgprintf ( "+===========================+" ) ;
  dbgprintf ( " " ) ;

  /*
   * event initialize
   */

  /* register eventHandler, create event queues */
  eventutilInitialization ( &evt_data ) ;

  /*
   * pad initialize
   */

  /* initialize controller io */
  padutilInitialization ( &evt_data, &priority ) ;

  /*
   * video initialize
   */

  /* initialize video */
  videoutilInitialization ( &vu_data, &evt_data, &priority ) ;

  /*
   * patching initialize
   */

  patchingInitialization ( &patched, &patch_data, &priority ) ;

  /* make sure patching was successful */
  if ( patched <= 0 )
  {
    argprintf ( "patching returned: %x", patched ) ;
    goto exit ;
  }

  /*
   * menu update initialize
   */

  /*
   * pointers for use by menu
   */
  mnu_data.menu = &menu ;
  mnu_data.update = &update ;
  mnu_data.line = &line ;
  mnu_data.indent = &indent ;
  mnu_data.action = &action ;
  mnu_data.focus = &focus ;

  /* initialize menu thread */
  menuInitialization ( &mnu_data, &evt_data, &dmp_data, &vu_data, &priority ) ;

  /*
   * images update initialize
   */

  /*
   * pointers for use by images
   */
  img_data.update = &update ;

  /* initialize menu thread */
  imagesInitialization ( &img_data, &evt_data, &dmp_data, &vu_data, &priority ) ;

  /*
   * dumping initialize
   */

  /* pointer to dumped */
  dmp_data.patched = &patched ;
  dmp_data.dumped = &dumped ;
  dmp_data.action = &action ;

  /* initialize dumping thread */
  dumpingInitialization ( &dmp_data, &evt_data, &vu_data, &priority ) ;

  /*
   * initialization complete
   */

  /* signal menu thread to start */
  syncutilMutexLock ( &mnu_data.mutex, NO_TIMEOUT ) ;
  dbgprintf( "signalling menuWorker" );
  syncutilCondSignal ( &mnu_data.cond ) ;
  syncutilMutexUnlock ( &mnu_data.mutex ) ;

  /* signal images thread to start */
  syncutilMutexLock ( &img_data.mutex, NO_TIMEOUT ) ;
  dbgprintf( "signalling imageWorker" );
  syncutilCondSignal ( &img_data.cond ) ;
  syncutilMutexUnlock ( &img_data.mutex ) ;

  /* signal dump thread to start */
  syncutilMutexLock ( &dmp_data.mutex, NO_TIMEOUT ) ;
  dbgprintf( "signalling dumpWorker" );
  syncutilCondSignal ( &dmp_data.cond ) ;
  syncutilMutexUnlock ( &dmp_data.mutex ) ;

  /*
   *  loop till finish
   */

  /* wait at first screen for user input */
  while ( evt_data.menu && evt_data.exitapp )
  {
    /* check if XMB */
    eventutilCheckCallback () ;

    /* exit if user quit via xmb */
    if ( evt_data.exitapp == 0 )
    {
      goto exit ;
    }

    /* save some CPU */
    usleep ( 100000 ) ;
  }

  /*
   *  finished close threads and exit
   */
exit:
  {
    dbgprintf ( "main stopping..." ) ;

    syscall_lv2_beep ( SYSCALL_BEEP_ONCE ) ; 

    /* toggle exitapp so threads quit */
    evt_data.exitapp = 0 ;

    sleep ( 2 ) ;

    /* finish remaining */
    eventutilFinish ( &evt_data ) ;

    dbgprintf ( "main exiting..." ) ;

    close_log ( &log_fd ) ;

    free ( path_ptr ) ;
    free ( filename_ptr ) ;

    sleep ( 2 ) ;

    exit ( EXIT_SUCCESS ) ;
  }
}

