#line 0 "source/leds_data.c"
/*
 * leds_data.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>

#include "common.h"
#include "debug.h"
#include "imageutil.h"
#include "tilesetutil.h"
#include "leds.h"


/*
 * defines
 */


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* png image data */
void
ledsDataInitialization ( void *l_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;
  void *tmp = NULL ;

  ledsData *leds_data = (ledsData*)l_data ;

  dbgprintf ( "initializing" ) ;

  leds_data->objects = LED_OBJECTS ;
  leds_data->states = LED_STATES ;
  leds_data->width = 61 ;
  leds_data->height = 61 ;
  leds_data->chromakey = CHROMAKEY ;

  /* allocate memory for tile object pointers */
  if ( ( tmp = calloc ( leds_data->objects, sizeof ( tileBitmapData* ) ) ) != NULL )
  {
    leds_data->tile = (tileBitmapData**) tmp ;
  }
  else
  {
    errprintf ( "ERROR: calloc() returned: %p", tmp ) ;
  }

  /* allocate object / state data memory */
  for ( i = 0; i < leds_data->objects; i++ )
  {
    /* allocate memory for tile object/state data */
    if ( ( tmp = calloc ( leds_data->states, sizeof ( tileBitmapData ) ) ) != NULL )
    {
      leds_data->tile[i] = (tileBitmapData*) tmp ;
    }
    else
    {
      errprintf ( "ERROR: object: %d, calloc() returned: %p", i, tmp ) ;
    }
  }

  /* red */
  leds_data->tile[LED_RED][LED_OFF].minx = 1 ;
  leds_data->tile[LED_RED][LED_OFF].miny = 1 ;

  leds_data->tile[LED_RED][LED_LOW].minx = 16 ;
  leds_data->tile[LED_RED][LED_LOW].miny = 1 ;

  leds_data->tile[LED_RED][LED_MED].minx = 31 ;
  leds_data->tile[LED_RED][LED_MED].miny = 1 ;

  leds_data->tile[LED_RED][LED_HIGH].minx = 46 ;
  leds_data->tile[LED_RED][LED_HIGH].miny = 1 ;

  /* green */
  leds_data->tile[LED_ORANGE][LED_OFF].minx = 1 ;
  leds_data->tile[LED_ORANGE][LED_OFF].miny = 13 ;

  leds_data->tile[LED_ORANGE][LED_LOW].minx = 16 ;
  leds_data->tile[LED_ORANGE][LED_LOW].miny = 13 ;

  leds_data->tile[LED_ORANGE][LED_MED].minx = 31 ;
  leds_data->tile[LED_ORANGE][LED_MED].miny = 13 ;

  leds_data->tile[LED_ORANGE][LED_HIGH].minx = 46 ;
  leds_data->tile[LED_ORANGE][LED_HIGH].miny = 13 ;

  /* blue */
  leds_data->tile[LED_YELLOW][LED_OFF].minx = 1 ;
  leds_data->tile[LED_YELLOW][LED_OFF].miny = 25 ;

  leds_data->tile[LED_YELLOW][LED_LOW].minx = 16 ;
  leds_data->tile[LED_YELLOW][LED_LOW].miny = 25 ;

  leds_data->tile[LED_YELLOW][LED_MED].minx = 31 ;
  leds_data->tile[LED_YELLOW][LED_MED].miny = 25 ;

  leds_data->tile[LED_YELLOW][LED_HIGH].minx = 46 ;
  leds_data->tile[LED_YELLOW][LED_HIGH].miny = 25 ;

  /* yellow */
  leds_data->tile[LED_GREEN][LED_OFF].minx = 1 ;
  leds_data->tile[LED_GREEN][LED_OFF].miny = 37 ;

  leds_data->tile[LED_GREEN][LED_LOW].minx = 16 ;
  leds_data->tile[LED_GREEN][LED_LOW].miny = 37 ;

  leds_data->tile[LED_GREEN][LED_MED].minx = 31 ;
  leds_data->tile[LED_GREEN][LED_MED].miny = 37 ;

  leds_data->tile[LED_GREEN][LED_HIGH].minx = 46 ;
  leds_data->tile[LED_GREEN][LED_HIGH].miny = 37 ;

  /* orange */
  leds_data->tile[LED_BLUE][LED_OFF].minx = 1 ;
  leds_data->tile[LED_BLUE][LED_OFF].miny = 49 ;

  leds_data->tile[LED_BLUE][LED_LOW].minx = 16 ;
  leds_data->tile[LED_BLUE][LED_LOW].miny = 49 ;

  leds_data->tile[LED_BLUE][LED_MED].minx = 31 ;
  leds_data->tile[LED_BLUE][LED_MED].miny = 49 ;

  leds_data->tile[LED_BLUE][LED_HIGH].minx = 46 ;
  leds_data->tile[LED_BLUE][LED_HIGH].miny = 49 ;

  for ( i = 0; i < leds_data->objects; i++ )
  {
    for ( j = 0; j < leds_data->states; j++ )
    {
      leds_data->tile[i][j].object = i ;
      leds_data->tile[i][j].state = j ;
      leds_data->tile[i][j].width = LED_WIDTH ;
      leds_data->tile[i][j].height = LED_HEIGHT ;
      leds_data->tile[i][j].pitch = 0;
      leds_data->tile[i][j].length = 0;
      leds_data->tile[i][j].chromakey = CHROMAKEY;
      leds_data->tile[i][j].offset = 0;
      leds_data->tile[i][j].ptr = NULL;
    }
  }

  dbgprintf ( "initialized" ) ;
}

