#line 0 "source/leds.c"
/*
 * leds.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "debug.h"
#include "videoutil.h"
#include "tilesetutil.h"

#include "leds.h"


/*
 * defines
 */


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* initialize leds for use */
void
ledsInitialization ( void *l_data )
{
  dbgprintf ( "initializing" ) ;

  /* initialize leds tileset */
  tilesetutilInitialization ( l_data ) ;

  /* initialize leds data */
  ledsDataInitialization ( l_data ) ;

  /* load leds tileset bitmap */
  ledsLoadTileset ( (void*)tileset_leds_png, tileset_leds_png_size, l_data ) ;

  /* load each tile bitmap from tileset bitmap */
  ledsLoadTiles ( l_data ) ;

  dbgprintf ( "initialized" ) ;
}

/* cleanup memory */
void
ledsFinish ( void *l_data )
{
  dbgprintf ( "finishing" ) ;

  tilesetutilFinish ( l_data ) ;

  dbgprintf ( "finished" ) ;
}

/* clear text buffer */
void
ledsBufferClear ( void *l_data )
{
  tilesetutilBufferClear ( 0x00, l_data ) ;
}

/* load tileset bitmap */
void
ledsLoadTileset ( void *mem, u32 size, void *l_data )
{
  tilesetutilLoadTilesetBitmapFromMemory ( mem, size, l_data ) ;
}

/* load led tile bitmap from tileset bitmap */
void
ledsLoadTiles ( void *l_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;

  /* load each led tile from tileset */
  for ( i = 0 ; i < LED_OBJECTS; i++ )
  {
    for ( j = 0 ; j < LED_STATES; j++ )
    {
      /* load led bitmap from tileset bitmap */
      tilesetutilLoadTileFromTileset ( (u8) i, (u8) j, l_data ) ;
    }
  }
}

/* draw led tile into buffer */
void
ledDraw ( u8 object, u8 state, u8 from, s32 x, s32 y, void *vu_data )
{
  videoutilTileBufferDrawBlend ( object, state, from, x, y, vu_data ) ;
}

