#line 0 "source/imagesUtils.c"
/*
 * imagesUtils.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "images.h"


/*
 * functions
 */

/* load images into buffers */
/*
void
imagesLoadImages ( imagesData *i_data, videoutilData *vu_data )
{
  dbgprintf ( "loading" ) ;

  videoutilImageLoadPngFromMemory ( IMAGE_FRAME, (void*)memdump_frame_png, memdump_frame_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_RED, (void*)memdump_frame_red_png, memdump_frame_red_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_GREEN, (void*)memdump_frame_green_png, memdump_frame_green_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_FRAME_BLUE, (void*)memdump_frame_blue_png, memdump_frame_blue_png_size, vu_data ) ;

  videoutilImageLoadPngFromMemory ( IMAGE_DUMP, (void*)buffer_1024_512_png, buffer_1024_512_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_PAGE, (void*)buffer_1024_1_png, buffer_1024_1_png_size, vu_data ) ;
  videoutilImageLoadPngFromMemory ( IMAGE_TRANS, (void*)transparency_1024_512_png, transparency_1024_512_png_size, vu_data ) ;

  dbgprintf ( "loaded" ) ;
}
*/

/* unload images from bufers */
/*
void
imagesUnloadImages ( imagesData *i_data, videoutilData *vu_data )
{
  dbgprintf ( "unloading" ) ;

  videoutilImageFinish ( vu_data ) ;

  dbgprintf ( "unloaded" ) ;
}
*/

/* get pointer to buffer bitmap */
/*
void
imagesGetBufferImagePointer ( imagesData *i_data, videoutilData *vu_data )
{
  argprintf ( "getting buffer bitmap pointer: %p:%p", &i_data->dump_data->buffer_bitmap_ptr, i_data->dump_data->buffer_bitmap_ptr ) ;

  videoutilImageGetPointer ( IMAGE_DUMP, (void**)&i_data->dump_data->buffer_bitmap_ptr, vu_data ) ;

  argprintf ( "got buffer bitmap pointer: %p:%p", &i_data->dump_data->buffer_bitmap_ptr, i_data->dump_data->buffer_bitmap_ptr ) ;
}
*/

/* get pointer to page bitmap */
/*
void
imagesGetPageImagePointer ( imagesData *i_data, videoutilData *vu_data )
{
  argprintf ( "getting page bitmap pointer: %p:%p", &i_data->dump_data->page_bitmap_ptr, i_data->dump_data->page_bitmap_ptr ) ;

  videoutilImageGetPointer ( IMAGE_PAGE, (void**)&i_data->dump_data->page_bitmap_ptr, vu_data ) ;

  argprintf ( "got page bitmap pointer: %p:%p", &i_data->dump_data->page_bitmap_ptr, i_data->dump_data->page_bitmap_ptr ) ;
}
*/

/* get pointer to buffer bitmap */
void
imagesGetBufferImagePointer ( imagesData *i_data, videoutilData *vu_data )
{
  videoutilImageGetPointer ( IMAGE_DUMP, (void**)&i_data->dump_data->buffer_bitmap_ptr, vu_data ) ;

/*
  argprintf ( "got buffer bitmap pointer: %p:%p",
              &i_data->dump_data->buffer_bitmap_ptr,
              i_data->dump_data->buffer_bitmap_ptr ) ;
*/
}

/* get pointer to page bitmap */
void
imagesGetPageImagePointer ( imagesData *i_data, videoutilData *vu_data )
{
/*
  argprintf ( "getting page bitmap pointers: %p:%p, [0] = %p:%p, [1] = %p:%p",
              &i_data->dump_data->page_bitmap_ptr,
              i_data->dump_data->page_bitmap_ptr,
              &i_data->dump_data->page_bitmap_ptr[0],
              i_data->dump_data->page_bitmap_ptr[0],
              &i_data->dump_data->page_bitmap_ptr[1],
              i_data->dump_data->page_bitmap_ptr[1],
              &i_data->dump_data->page_bitmap_ptr[2],
              i_data->dump_data->page_bitmap_ptr[2],
              &i_data->dump_data->page_bitmap_ptr[3],
              i_data->dump_data->page_bitmap_ptr[3] ) ;
*/

  videoutilImageGetPointer ( IMAGE_PAGE1, (void**)&i_data->dump_data->page_bitmap_ptr[0], vu_data ) ;
  videoutilImageGetPointer ( IMAGE_PAGE2, (void**)&i_data->dump_data->page_bitmap_ptr[1], vu_data ) ;
  videoutilImageGetPointer ( IMAGE_PAGE3, (void**)&i_data->dump_data->page_bitmap_ptr[2], vu_data ) ;
  videoutilImageGetPointer ( IMAGE_PAGE4, (void**)&i_data->dump_data->page_bitmap_ptr[3], vu_data ) ;

/*
  argprintf ( "got page bitmap pointers: %p:%p, [0] = %p:%p, [1] = %p:%p, [2] = %p:%p, [3] = %p:%p",
              &i_data->dump_data->page_bitmap_ptr,
              i_data->dump_data->page_bitmap_ptr,
              &i_data->dump_data->page_bitmap_ptr[0],
              i_data->dump_data->page_bitmap_ptr[0],
              &i_data->dump_data->page_bitmap_ptr[1],
              i_data->dump_data->page_bitmap_ptr[1],
              &i_data->dump_data->page_bitmap_ptr[2],
              i_data->dump_data->page_bitmap_ptr[2],
              &i_data->dump_data->page_bitmap_ptr[3],
              i_data->dump_data->page_bitmap_ptr[3] ) ;
*/
}

/* load tilesets and tiles into buffers */
void
imagesLoadTilesets ( imagesData *i_data, videoutilData *vu_data )
{
  dbgprintf ( "loading" ) ;

  ledsInitialization ( i_data->leds_data ) ;
  dipswitchInitialization ( i_data->dipswitch_data ) ;

  dbgprintf ( "loaded" ) ;
}

/* unload tilesets from buffers */
void
imagesUnloadTilesets ( imagesData *i_data, videoutilData *vu_data )
{
  dbgprintf ( "unloading" ) ;

  //ledsFinish ( i_data->leds_data ) ;
  //dipswitchFinish ( i_data->dipswitch_data ) ;

  dbgprintf ( "unloaded" ) ;
}

inline s32
imagesReadExitapp ( eventData *e_data )
{
  //dbgprintf ( "exitapp read" ) ;

  syncutilRwLockReadLock ( &e_data->rwlock, TIMEOUT ) ;
  s32 ret = e_data->exitapp ;
  syncutilRwLockReadUnlock ( &e_data->rwlock ) ;

  return ( ret ) ;
}

inline void
imagesWriteExitapp ( eventData *e_data )
{
  dbgprintf ( "exit toggle" ) ;

  syncutilRwLockWriteLock ( &e_data->rwlock, NO_TIMEOUT ) ;
  e_data->exitapp = 0 ;
  syncutilRwLockWriteUnlock ( &e_data->rwlock ) ;
}

/* get random u32 value */
inline u32
imagesGetRandomSeed ()
{
  u32 seed = 0 ;
  lv2syscall3 ( 865, 2, (u64)&seed, sizeof ( u32 ) ) ;
  return ( seed ) ;
}

/* get random value 1 - size */
inline u8
imagesGetRandom ( u8 size )
{
  u32 random = 0 ;

  //lv2syscall3 ( 865, 2, (u64)&random, sizeof ( u32 ) ) ;
  random = ( rand() % size + 1 ) ;

  if ( random < 1 )
  {
    random = 1 ;
  }
  else if ( random > size )
  {
    random = size ;
  }

  return ( (u8)random ) ;
}

