#line 0 "source/imagesReceive.c"
/*
 * imagesReceive.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "images.h"


/*
 * functions
 */

/* receive images update via event queue */
inline s32
imagesReceiveVideoUpdate ( imagesData *i_data )
{
  s32 ret = 0 ;

  eventutilReceiveEventQueue ( i_data->img_queue, i_data->img_event, NO_TIMEOUT ) ;

  if ( i_data->img_event->data_1 > 0 || i_data->img_event->data_2 > 0 )
  {
    ret = i_data->img_event->data_2 ;
  }
  else if ( i_data->img_event->data_1 == IMAGE_EXIT && i_data->img_event->data_2 == IMAGE_EXIT && i_data->img_event->data_3 == IMAGE_EXIT )
  {
    ret = IMAGE_EXIT ;
  }

  return ( ret ) ;
}

