#line 0 "source/imagesDraw.c"
/*
 * imagesDraw.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "images.h"


/*
 * defines
 */

#define RANDOM(size) imagesGetRandom ( size )
#define RANDOM3() RANDOM( 3 )
#define RANDOM4() RANDOM( 4 )


/*
 * functions
 */

/* draw images into buffer */
void
imagesDraw ( imagesData *i_data, videoutilData *vu_data )
{
  /* draw memory LEDs */
  i_data->memleds = 0 ;
  imagesDrawMemoryLeds ( i_data, vu_data ) ;

  /* draw dipswitch state */
  i_data->dipswitch = 0 ;
  imagesDrawDipswitch ( i_data, vu_data ) ;

  /* draw IO LEDs */
  i_data->ioleds = 0 ;
  imagesDrawIoLeds ( i_data, vu_data ) ;

  /* draw progress LEDs */
  i_data->progleds = 0 ;
  imagesDrawProgressLeds ( i_data, vu_data ) ;
}

/* draw background image into buffer */
void
imagesDrawImages ( imagesData *i_data, videoutilData *vu_data )
{
  dbgprintf( "drawing images" );

  //TIMING_START() ;
  imagesDrawImageBackground ( i_data, vu_data ) ;
  imagesDrawImageDumpBuffer ( i_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;

  dbgprintf( "drew images" );
}

/* draw dipswitch */
void
imagesDrawDipswitch ( imagesData *i_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  switch ( i_data->dipswitch )
  {
    case DIP_ONE:
      imagesDrawDip1 ( i_data, vu_data ) ;
      break ;
    case DIP_TWO:
      imagesDrawDip2 ( i_data, vu_data ) ;
      break ;
    case DIP_THREE:
      imagesDrawDip3 ( i_data, vu_data ) ;
      break ;
    default:
      imagesDrawDip0 ( i_data, vu_data ) ;
      break ;
  }
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw 7 segment LED display */
/*
void
imagesDrawSevenSegment ( imagesData *i_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  imagesDrawDigit1 ( DIGIT_ZERO, DIGIT_OFF, i_data, vu_data ) ;
  imagesDrawDigit2 ( DIGIT_ZERO, DIGIT_DOTON, i_data, vu_data ) ;
  imagesDrawDigit3 ( DIGIT_ZERO, DIGIT_NODOT, i_data, vu_data ) ;
  imagesDrawDigit4 ( DIGIT_ONE, DIGIT_NODOT, i_data, vu_data ) ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}
*/

/* draw buttons */
/*
void
imagesDrawButtons ( imagesData *i_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  imagesDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, i_data, vu_data ) ;
  i_data->buttons = 0 ;
  //TIMING_END() ;
  //TIMING_PRINT() ;
}
*/

/* draw memory LEDs */
void
imagesDrawMemoryLeds ( imagesData *i_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  switch ( i_data->memleds )
  {
    case LED_LV1:
      imagesDrawMemLeds1 ( i_data, vu_data ) ;
      break ;
    case LED_LV2:
      imagesDrawMemLeds2 ( i_data, vu_data ) ;
      break ;
    case LED_MMIO:
      imagesDrawMemLeds3 ( i_data, vu_data ) ;
      break ;
    default:
      imagesDrawMemLeds0 ( i_data, vu_data ) ;
      break ;
  }
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw IO LEDs */
void
imagesDrawIoLeds ( imagesData *i_data, videoutilData *vu_data )
{
  //TIMING_START() ;
  switch ( i_data->ioleds )
  {
    case LED_MEM:
      imagesDrawIoLeds1 ( i_data, vu_data ) ;
      break ;
    case LED_FLASH:
      imagesDrawIoLeds2 ( i_data, vu_data ) ;
      break ;
    case LED_DISK:
      imagesDrawIoLeds3 ( i_data, vu_data ) ;
      break ;
    default:
      imagesDrawIoLeds0 ( i_data, vu_data ) ;
      break ;
  }
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw progress LEDs */
void
imagesDrawProgressLeds ( imagesData *i_data, videoutilData *vu_data )
{
  s32 progress = i_data->progleds ;

  //TIMING_START() ;
  if ( progress > LED_PROG0 )
  {
    if ( progress < LED_PROG10 )
    {
      if ( progress < LED_PROG3 )
      {
        imagesDrawProgLeds3 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG6 )
      {
        imagesDrawProgLeds6 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds9 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG10 )
    {
      imagesDrawProgLeds10 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG20 )
    {
      if ( progress < LED_PROG13 )
      {
        imagesDrawProgLeds13 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG16 )
      {
        imagesDrawProgLeds16 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds19 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG20 )
    {
      imagesDrawProgLeds20 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG30 )
    {
      if ( progress < LED_PROG23 )
      {
        imagesDrawProgLeds23 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG26 )
      {
        imagesDrawProgLeds26 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds29 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG30 )
    {
      imagesDrawProgLeds30 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG40 )
    {
      if ( progress < LED_PROG33 )
      {
        imagesDrawProgLeds33 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG36 )
      {
        imagesDrawProgLeds36 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds39 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG40 )
    {
      imagesDrawProgLeds40 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG50 )
    {
      if ( progress < LED_PROG43 )
      {
        imagesDrawProgLeds43 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG46 )
      {
        imagesDrawProgLeds46 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds49 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG50 )
    {
      imagesDrawProgLeds50 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG60 )
    {
      if ( progress < LED_PROG53 )
      {
        imagesDrawProgLeds53 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG56 )
      {
        imagesDrawProgLeds56 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds59 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG60 )
    {
      imagesDrawProgLeds60 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG70 )
    {
      if ( progress < LED_PROG63 )
      {
        imagesDrawProgLeds63 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG66 )
      {
        imagesDrawProgLeds66 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds69 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG70 )
    {
      imagesDrawProgLeds70 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG80 )
    {
      if ( progress < LED_PROG73 )
      {
        imagesDrawProgLeds73 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG76 )
      {
        imagesDrawProgLeds76 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds79 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG80 )
    {
      imagesDrawProgLeds80 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG90 )
    {
      if ( progress < LED_PROG83 )
      {
        imagesDrawProgLeds83 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG86 )
      {
        imagesDrawProgLeds86 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds89 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG90 )
    {
      imagesDrawProgLeds90 ( i_data, vu_data ) ;
    }
    else if ( progress < LED_PROG100 )
    {
      if ( progress < LED_PROG93 )
      {
        imagesDrawProgLeds93 ( i_data, vu_data ) ;
      }
      else if ( progress < LED_PROG96 )
      {
        imagesDrawProgLeds96 ( i_data, vu_data ) ;
      }
      else
      {
        imagesDrawProgLeds99 ( i_data, vu_data ) ;
      }
    }
    else if ( progress == LED_PROG100 )
    {
      imagesDrawProgLeds100 ( i_data, vu_data ) ;
    }
  }
  else
  {
    imagesDrawProgLeds0 ( i_data, vu_data ) ;
  }
  
  //TIMING_END() ;
  //TIMING_PRINT() ;
}

/* draw background image */
void
imagesDrawImageBackground ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawImage ( RANDOM4(), 0, 0, 0, i_data, vu_data ) ;
}

/* draw main buffer image */
void
imagesDrawImageMainBuffer ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawImage ( IMAGE_MAIN, 0, 128, 135, i_data, vu_data ) ;
}

/* draw help buffer image */
void
imagesDrawImageHelpBuffer ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawImage ( IMAGE_HELP, 0, 128, 135, i_data, vu_data ) ;
}

/* draw about buffer image */
void
imagesDrawImageAboutBuffer ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawImage ( IMAGE_ABOUT, 0, 128, 135, i_data, vu_data ) ;
}

/* draw dump buffer image */
void
imagesDrawImageDumpBuffer ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawImage ( IMAGE_DUMP, 0, 128, 135, i_data, vu_data ) ;
}

/* △  */
/* draw triangle button */
/*
void
imagesDrawButtonTriangle ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawButton ( BUTTON_TRIANGLE, BUTTON_DOWN, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, i_data, vu_data ) ;
}
*/

/* ◯  */
/* draw circle button */
/*
void
imagesDrawButtonCircle ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CIRCLE, BUTTON_DOWN, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, i_data, vu_data ) ;
}
*/

/* ✕  */
/* draw cross button */
/*
void
imagesDrawButtonCross ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CROSS, BUTTON_DOWN, BUTTON_CROSS_X, BUTTON_CROSS_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_SQUARE, BUTTON_UP, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, i_data, vu_data ) ;
}
*/

/* ☐  */
/* draw square button */
/*
void
imagesDrawButtonSquare ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawButton ( BUTTON_TRIANGLE, BUTTON_UP, BUTTON_TRIANGLE_X, BUTTON_TRIANGLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CIRCLE, BUTTON_UP, BUTTON_CIRCLE_X, BUTTON_CIRCLE_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_CROSS, BUTTON_UP, BUTTON_CROSS_X, BUTTON_CROSS_Y, i_data, vu_data ) ;
  imagesDrawButton ( BUTTON_SQUARE, BUTTON_DOWN, BUTTON_SQUARE_X, BUTTON_SQUARE_Y, i_data, vu_data ) ;
}
*/

/* draw digit 1 */
/*
void
imagesDrawDigit1 ( u8 number, u8 state, imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDigit ( number, state, DIGIT_7SEG1_X, DIGIT_7SEG1_Y, i_data, vu_data ) ;
}
*/

/* draw digit 2 */
/*
void
imagesDrawDigit2 ( u8 number, u8 state, imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDigit ( number, state, DIGIT_7SEG2_X, DIGIT_7SEG2_Y, i_data, vu_data ) ;
}
*/

/* draw digit 3 */
/*
void
imagesDrawDigit3 ( u8 number, u8 state, imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDigit ( number, state, DIGIT_7SEG3_X, DIGIT_7SEG3_Y, i_data, vu_data ) ;
}
*/

/* draw digit 4 */
/*
void
imagesDrawDigit4 ( u8 number, u8 state, imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDigit ( number, state, DIGIT_7SEG4_X, DIGIT_7SEG4_Y, i_data, vu_data ) ;
}
*/

/* draw dip 0 */
void
imagesDrawDip0 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDip ( DIP_ONE, DIP_OFF, DIP_SWITCH1_X, DIP_SWITCH1_Y, i_data, vu_data ) ;
  imagesDrawDip ( DIP_TWO, DIP_OFF, DIP_SWITCH2_X, DIP_SWITCH2_Y, i_data, vu_data ) ;
}

/* draw dip 1 */
void
imagesDrawDip1 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDip ( DIP_ONE, DIP_ON, DIP_SWITCH1_X, DIP_SWITCH1_Y, i_data, vu_data ) ;
  imagesDrawDip ( DIP_TWO, DIP_OFF, DIP_SWITCH2_X, DIP_SWITCH2_Y, i_data, vu_data ) ;
}

/* draw dip 2 */
void
imagesDrawDip2 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDip ( DIP_ONE, DIP_OFF, DIP_SWITCH1_X, DIP_SWITCH1_Y, i_data, vu_data ) ;
  imagesDrawDip ( DIP_TWO, DIP_ON, DIP_SWITCH2_X, DIP_SWITCH2_Y, i_data, vu_data ) ;
}

/* draw dip 2 */
void
imagesDrawDip3 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawDip ( DIP_ONE, DIP_ON, DIP_SWITCH1_X, DIP_SWITCH1_Y, i_data, vu_data ) ;
  imagesDrawDip ( DIP_TWO, DIP_ON, DIP_SWITCH2_X, DIP_SWITCH2_Y, i_data, vu_data ) ;
}

/* draw memory LEDs NONE */
void
imagesDrawMemLeds0 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_LV1_X, LED_LV1_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_LV2_X, LED_LV2_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_MMIO_X, LED_MMIO_Y, i_data, vu_data ) ;
}

/* draw memory LEDs MMIO */
void
imagesDrawMemLeds1 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_LV1_X, LED_LV1_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_LV2_X, LED_LV2_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_MMIO_X, LED_MMIO_Y, i_data, vu_data ) ;
}

/* draw memory LEDs LV1 */
void
imagesDrawMemLeds2 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_LV1_X, LED_LV1_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_LV2_X, LED_LV2_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_MMIO_X, LED_MMIO_Y, i_data, vu_data ) ;
}

/* draw memory LEDs LV2 */
void
imagesDrawMemLeds3 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_LV1_X, LED_LV1_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_LV2_X, LED_LV2_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_MMIO_X, LED_MMIO_Y, i_data, vu_data ) ;
}

/* draw IO LEDs NONE */
void
imagesDrawIoLeds0 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_MEM_X, LED_MEM_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_FLASH_X, LED_FLASH_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_DISK_X, LED_DISK_Y, i_data, vu_data ) ;
}

/* draw IO LEDs FLASH */
void
imagesDrawIoLeds1 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_MEM_X, LED_MEM_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_FLASH_X, LED_FLASH_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_DISK_X, LED_DISK_Y, i_data, vu_data ) ;
}

/* draw IO LEDs MEM */
void
imagesDrawIoLeds2 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_MEM_X, LED_MEM_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_FLASH_X, LED_FLASH_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_DISK_X, LED_DISK_Y, i_data, vu_data ) ;
}

/* draw IO LEDs DISK */
void
imagesDrawIoLeds3 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_MEM_X, LED_MEM_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_FLASH_X, LED_FLASH_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_DISK_X, LED_DISK_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 0% */
void
imagesDrawProgLeds0 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 3% */
void
imagesDrawProgLeds3 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 6% */
void
imagesDrawProgLeds6 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 9% */
void
imagesDrawProgLeds9 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 10% */
void
imagesDrawProgLeds10 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 13% */
void
imagesDrawProgLeds13 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 16% */
void
imagesDrawProgLeds16 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 19% */
void
imagesDrawProgLeds19 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 20% */
void
imagesDrawProgLeds20 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 23% */
void
imagesDrawProgLeds23 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 26% */
void
imagesDrawProgLeds26 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 29% */
void
imagesDrawProgLeds29 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 30% */
void
imagesDrawProgLeds30 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 33% */
void
imagesDrawProgLeds33 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 36% */
void
imagesDrawProgLeds36 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 39% */
void
imagesDrawProgLeds39 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 40% */
void
imagesDrawProgLeds40 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 43% */
void
imagesDrawProgLeds43 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 46% */
void
imagesDrawProgLeds46 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 49% */
void
imagesDrawProgLeds49 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 50% */
void
imagesDrawProgLeds50 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 53% */
void
imagesDrawProgLeds53 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 56% */
void
imagesDrawProgLeds56 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 59% */
void
imagesDrawProgLeds59 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 60% */
void
imagesDrawProgLeds60 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 63% */
void
imagesDrawProgLeds63 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 66% */
void
imagesDrawProgLeds66 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 69% */
void
imagesDrawProgLeds69 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 70% */
void
imagesDrawProgLeds70 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 73% */
void
imagesDrawProgLeds73 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 76% */
void
imagesDrawProgLeds76 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 79% */
void
imagesDrawProgLeds79 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 80% */
void
imagesDrawProgLeds80 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 83% */
void
imagesDrawProgLeds83 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ; 
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 86% */
void
imagesDrawProgLeds86 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 89% */
void
imagesDrawProgLeds89 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 90% */
void
imagesDrawProgLeds90 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, LED_OFF, LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 93% */
void
imagesDrawProgLeds93 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_RED, RANDOM3(), LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
} 

/* draw progress LEDs 96% */
void
imagesDrawProgLeds96 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_ORANGE, RANDOM3(), LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 99% */
void
imagesDrawProgLeds99 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_YELLOW, RANDOM3(), LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* draw progress LEDs 100% */
void
imagesDrawProgLeds100 ( imagesData *i_data, videoutilData *vu_data )
{
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG100_X, LED_PROG100_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG90_X, LED_PROG90_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG80_X, LED_PROG80_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG70_X, LED_PROG70_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG60_X, LED_PROG60_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG50_X, LED_PROG50_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG40_X, LED_PROG40_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG30_X, LED_PROG30_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG20_X, LED_PROG20_Y, i_data, vu_data ) ;
  imagesDrawLed ( LED_GREEN, RANDOM3(), LED_PROG10_X, LED_PROG10_Y, i_data, vu_data ) ;
}

/* image */
void
imagesDrawImage ( u8 index, u8 from, s32 x, s32 y, imagesData *i_data, videoutilData *vu_data )
{
  videoutilImageBufferDrawBlend ( index, from, x, y, vu_data ) ;
}

/* button */
/*
void
imagesDrawButton ( u8 object, u8 state, s32 x, s32 y, imagesData *i_data, videoutilData *vu_data )
{
  vu_data->tileset_data = i_data->buttons_data ;

  buttonDraw ( object, state, 0, x, y, vu_data ) ;

  i_data->buttons = object ;
}
*/

/* digit */
/*
void
imagesDrawDigit ( u8 object, u8 state, s32 x, s32 y, imagesData *i_data, videoutilData *vu_data )
{
  vu_data->tileset_data = i_data->digits_data ;

  digitDraw ( object, state, 0, x, y, vu_data ) ;
}
*/

/* dip */
void
imagesDrawDip ( u8 object, u8 state, s32 x, s32 y, imagesData *i_data, videoutilData *vu_data )
{
  vu_data->tileset_data = i_data->dipswitch_data ;

  dipDraw ( object, state, 0, x, y, vu_data ) ;
}

/* led */
void
imagesDrawLed ( u8 object, u8 state, s32 x, s32 y, imagesData *i_data, videoutilData *vu_data )
{
  vu_data->tileset_data = i_data->leds_data ;

  ledDraw ( object, state, 0, x, y, vu_data ) ;
}

