#line 0 "source/imagesCheck.c"
/*
 * imagesCheck.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "images.h"


/*
 * functions
 */

/* check if images need to be redrawn */
void
imagesCheckUpdate ( imagesData *i_data )
{
  s32 ret = imagesReceiveVideoUpdate ( i_data ) ;

  switch ( ret )
  {
    case IMAGE_EXIT:
      imagesWriteExitapp ( i_data->e_data ) ;  
      break ;
    case IMAGE_UPDATE:
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_MAIN:
      imagesUpdateMainBufferImages ( i_data, i_data->vu_data ) ;
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_HELP:
      imagesUpdateHelpBufferImages ( i_data, i_data->vu_data ) ;
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_ABOUT:
      imagesUpdateAboutBufferImages ( i_data, i_data->vu_data ) ;
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_DUMP:
      imagesUpdateDumpBufferImages ( i_data, i_data->vu_data ) ;
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_MEMLED:
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_IOLED:
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    case IMAGE_UPDATE_PROGLED:
      imagesUpdateDipswitch ( i_data, i_data->vu_data ) ;
      imagesUpdateMemoryLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateIoLeds ( i_data, i_data->vu_data ) ;
      imagesUpdateProgressLeds ( i_data, i_data->vu_data ) ;
      break ;
    default:
      argprintf ( "default: %d", ret ) ;
      break ;
  }
}

