#line 0 "source/images.c"
/*
 * images.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "images.h"


/*
 * functions
 */

/* initialize images */
void
imagesInitialization ( imagesData *i_data, eventData *e_data, dumpData *d_data, videoutilData *vu_data, u64 *priority )
{
  dbgprintf( "initializing" );

  *i_data->update = 0 ;

  i_data->e_data = e_data ;
  i_data->exitapp = &e_data->exitapp ;

  i_data->dump_data = d_data ;

  i_data->vu_data = vu_data ;

  dbgprintf( "sync stuff" );

  /* initialize mutex attributes */
  i_data->mutex_attr.key = IMAGES_KEY ;
  i_data->mutex_attr.attr_protocol = SYS_MUTEX_PROTOCOL_FIFO ;
  i_data->mutex_attr.attr_pshared = SYS_MUTEX_ATTR_PSHARED ;
  i_data->mutex_attr.attr_recursive = SYS_MUTEX_ATTR_RECURSIVE ;
  i_data->mutex_attr.attr_adaptive = SYS_MUTEX_ATTR_ADAPTIVE ;

  /* initialize reader/writer attributes */
  i_data->rwlock_attr.key = IMAGES_KEY ;
  i_data->rwlock_attr.attr_protocol = SYS_RWLOCK_PROTOCOL_FIFO ;
  i_data->rwlock_attr.attr_pshared = SYS_RWLOCK_ATTR_PSHARED ;
  i_data->rwlock_attr.flags = 0 ;

  /* initialize condition attributes */
  i_data->cond_attr.key = IMAGES_KEY ;
  i_data->cond_attr.attr_pshared = SYS_COND_ATTR_PSHARED ;

  /* initialize key */
  i_data->key = SYS_EVENT_QUEUE_KEY_LOCAL ;

  dbgprintf( "event stuff" );

  /* images events */
  i_data->vid_event = &e_data->vid_event ;
  i_data->vid_queue = &e_data->vid_queue ;
  i_data->vid_queue_attr = &e_data->vid_queue_attr ;
  i_data->vid_port = &e_data->vid_port ;

  /* images events */
  i_data->img_event = &e_data->img_event ;
  i_data->img_queue = &e_data->img_queue ;
  i_data->img_queue_attr = &e_data->img_queue_attr ;
  i_data->img_port = &e_data->img_port ;

  dbgprintf( "create sync stuff" );

  /* create mutex */
  syncutilMutexCreate ( &i_data->mutex, &i_data->mutex_attr ) ;

  /* create reader/writer lock */
  syncutilRwLockCreate ( &i_data->rwlock, &i_data->rwlock_attr ) ;

  /* create cond */
  syncutilCondCreate ( &i_data->cond, &i_data->mutex, &i_data->cond_attr ) ;

  /* start images thread */
  dbgprintf( "thread spawn" );
  imagesThread ( i_data, priority ) ;

  dbgprintf( "initialized" );
}

/* release images resources */
void
imagesFinish ( imagesData *i_data )
{
  dbgprintf( "finishing" );

  /* free tilesets */
  imagesUnloadTilesets ( i_data, i_data->vu_data ) ;

  /* free images */
  //imagesUnloadImages ( i_data, i_data->vu_data ) ;

  /* destroy rwlock */
  syncutilRwLockDestroy ( &i_data->rwlock ) ;

  /* destroy cond */
  syncutilCondDestroy ( &i_data->cond ) ;

  /* destroy mutex */
  syncutilMutexDestroy ( &i_data->mutex ) ;

  dbgprintf( "finished" );
}

/* images thread */
void
imagesThread ( imagesData *i_data, u64 *priority )
{
  argprintf( "starting :: priority: %016"PRIx64, *priority );

  /* lock images mutex */
  syncutilMutexLock ( &i_data->mutex, TIMEOUT ) ;

  /* create images thread */
  dbgprintf( "thread create" );
  sysThreadCreate ( &i_data->ppu_thread, imagesWorker, ( void * ) i_data,
                    *priority += 10, ( size_t ) 0x100000, 0,
                    "imagesWorker" ) ;

  /* wait for images thread to be ready */
  dbgprintf( "thread waiting" );
  syncutilCondWait ( &i_data->cond, NO_TIMEOUT ) ;

  /* release lock */
  syncutilMutexUnlock ( &i_data->mutex ) ;

  dbgprintf( "started" );
}

/* images worker */
void
imagesWorker ( void *arg )
{
  dbgprintf( "starting" );

  /* cast the void *arg to imagesData */
  imagesData* i_data = ( imagesData* ) arg ;

  /* prime pseudo-random generator */
  u32 seed = imagesGetRandomSeed() ;
  srand ( seed ) ;

  /* pointers for dumping */
  i_data->dump_data->dipswitch = &i_data->dipswitch ;
  i_data->dump_data->memleds = &i_data->memleds ;
  i_data->dump_data->ioleds = &i_data->ioleds ;
  i_data->dump_data->progleds = &i_data->progleds ;

  /* leds data */
  ledsData led_data ;
  led_data.tileset_buffer = i_data->vu_data->tileset_buffer ;
  i_data->leds_data = &led_data ;
  i_data->leds_buffer = i_data->vu_data->tileset_buffer ;

  /* dipswitch data */
  dipswitchData dip_data ;
  dip_data.tileset_buffer = i_data->vu_data->tileset_buffer ;
  i_data->dipswitch_data = &dip_data ;
  i_data->dipswitch_buffer = i_data->vu_data->tileset_buffer ;

  /* load tilesets into buffers */
  imagesLoadTilesets ( i_data, i_data->vu_data ) ;

  /* load bitmap font into buffers */
  //imagesLoadBitmapFont ( i_data, i_data->vu_data ) ;

  dbgprintf( "signalling" );

  /* signal main thread is ready */
  syncutilCondSignal ( &i_data->cond ) ;

  /* lock mutex */
  syncutilMutexLock ( &i_data->mutex, TIMEOUT ) ;

  dbgprintf( "waiting" );

  /* wait for main to be ready */
  syncutilCondWait ( &i_data->cond, NO_TIMEOUT ) ;

  /* release lock */
  syncutilMutexUnlock ( &i_data->mutex ) ;

  /* image pointers */
  imagesGetBufferImagePointer ( i_data, i_data->vu_data ) ;
  imagesGetPageImagePointer ( i_data, i_data->vu_data ) ;

  dbgprintf( "entering loop" );

  /* draw images */
  imagesDraw ( i_data, i_data->vu_data ) ;

  /* render frames until exit */
  while ( *i_data->exitapp )
  {
    /* check images update */
    imagesCheckUpdate ( i_data ) ;

    usleep ( 500 ) ;
  }

  dbgprintf( "left loop" );

  /* finish */
  imagesFinish ( i_data ) ;

  dbgprintf( "thread exiting" );

  /* exit thread */
  sysThreadExit ( 0 ) ;
}

