#line 1 "source/idps.c"
/*
 * idps.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "debug.h"
#include "patchutil.h"


/*
 * defines
 */

#define AIM_PACKET_ID_GET_DEV_ID                        0x19003
#define IDPS_SIZE                                       16

#define INDI_INFO_MGR_PACKET_ID_GET_DATA_SIZE_BY_INDEX  0x17001
#define INDI_INFO_MGR_PACKET_ID_GET_DATA_BY_INDEX       0x17002
#define EID0_INDEX                                      0


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

s32
idps_get_via_console_id ( u8 *idps )
{
  s32 ret = 0 ;

  if ( ( ret = storage_get_console_id ( idps) ) )
  {
    argprintf ("storage_get_console_id failed (0x%08x)", ret );
    return 1 ;
  }

  return ( 0 ) ;
}

s32
idps_get_via_aim ( u8 *idps )
{
  s32 ret = 0 ;

  /* Use AIM to get IDPS */
  if ( ( ret = interface_ss_aim (AIM_PACKET_ID_GET_DEV_ID, (u64)idps) ) )
  {
    argprintf ("interface_ss_aim_if(GET_DEV_ID) failed (0x%08x)", ret );
    return 1 ;
  }

  return ( 0 ) ;
}

s32
idps_get_via_indi ( u8 *idps )
{
  s32 ret = 0 ;
  u64 eid0_size = 0ULL ;
  u8 eid0[4096] = { 0 } ;

  /* Use Indi Info Manager to get EID0 */
  if ( ( ret = interface_ss_indi_info_mgr (INDI_INFO_MGR_PACKET_ID_GET_DATA_SIZE_BY_INDEX, EID0_INDEX, (u64) &eid0_size, 0, 0) ) )
  {
    argprintf ("interface_ss_indi_info_mgr(GET_DATA_SIZE_BY_INDEX) failed (0x%08x)", ret );
    return ( 1 ) ;
  }

  argprintf ("EID0 size %ld", eid0_size);

  if ( ( ret = interface_ss_indi_info_mgr (INDI_INFO_MGR_PACKET_ID_GET_DATA_BY_INDEX, EID0_INDEX, (u64)eid0, sizeof(eid0), (u64)&eid0_size) ) )
  {
    argprintf ("interface_ss_indi_info_mgr(GET_DATA_BY_INDEX) failed (0x%08x)", ret );
    return ( 1 ) ;
  }

  argprintf ("EID0 size %ld", eid0_size);

  memcpy(idps, eid0, IDPS_SIZE);

  return ( 0 ) ;
}

