#line 0 "source/file.c"
/*
 * file.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "patchutil.h"
#include "aioutil.h"
#include "syncutil.h"


/*
 * defines
 */

#define TMP_DIR     "/tmp"
#define TMP_FILE    "memdump.tmp"

#define AIO_BUFFER  ( 32 * PAGE_SIZE )
#define FILE_PATHS  10


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;

static const char *dump_path[] = {
  "/dev_usb000",
  "/dev_usb001",
  "/dev_usb002",
  "/dev_usb003",
  "/dev_usb004",
  "/dev_usb005",
  "/dev_usb006",
  "/dev_usb007",
  "/dev_hdd0/tmp",
  "/dev_hdd0/game_debug",
};


/*
 * functions
 */

s32
fileMountpoint ( s32 type, char *path_ret )
{
  s32 fd = 0 ;
  s32 ret = -1 ;
  char path[512] ;
  s32 i ;

  if ( type == 1 )
  {
    strcpy ( path_ret, DEV_HDD_PATH ) ;
    snprintf ( path, ( strlen ( path_ret ) + strlen ( TMP_FILE ) + 2 ), "%s/%s", path_ret, TMP_FILE ) ;
    argprintf ( "trying path '%s'", path ) ;
    if ( ( ret = sysFsOpen ( path, SYS_O_RDWR | SYS_O_CREAT | SYS_O_TRUNC, &fd, NULL, 0 ) ) != 0 )
    {
      errprintf ( "sysFsOpen %s returned: 0x%x", path, ret ) ;
      goto error ;
    }
  }
  else if ( type == 2 )
  {
    for (i = 0; i < FILE_PATHS; i++)
    {
      strcpy ( path_ret, dump_path[i] ) ;
      snprintf ( path, ( strlen ( path_ret ) + strlen ( TMP_FILE ) + 2 ), "%s/%s", path_ret, TMP_FILE ) ;
      argprintf ( "trying path '%s'", path ) ;
      ret = sysFsOpen ( path, SYS_O_RDWR | SYS_O_CREAT | SYS_O_TRUNC, &fd, NULL, 0 ) ;
      if ( fd )
      {
        break;
      }
    }
  }

  if ( fd )
  {
    sysFsClose ( fd ) ;
    sysFsChmod ( path, 0170777 ) ;
  }
  else
  {
    errprintf ( "sysFsOpen %s failed!", path ) ;
    goto error ;
  }

  sysFsUnlink ( path ) ;

  return ( 0 ) ;

error:
  return ( -1 ) ;
}

/* open_file */
s32
fileAioOpen ( s32 type, const char *filename, aioData *aio_data )
{
  s32 ret = -1 ;
  char *path_ptr = NULL ;
  char *filename_ptr = NULL ;

  if ( ( path_ptr = malloc ( 512 ) ) == NULL )
  {
    errprintf ( "malloc mount point returned: %p", path_ptr ) ;
    goto error ;
  }

  if ( ( filename_ptr = malloc ( 512 ) ) == NULL )
  {
    errprintf ( "malloc path returned: %p", path_ptr ) ;
    goto error ;
  }

  if ( ( ret = fileMountpoint ( type, path_ptr ) ) == 0 )
  {
    if ( ( ret = aioutilInitialize ( aio_data, path_ptr ) ) != 0 )
    {
      errprintf ( "aioutilInitialize returned: 0x%x", ret ) ;
      goto error ;
    }
  }
  else
  {
    errprintf ( "mount point could not be determined, returned: 0x%x", ret ) ;
    goto error ;
  }

  snprintf ( filename_ptr, ( strlen ( path_ptr ) + strlen ( filename ) + 5 + strlen ( FILE_EXTENSION ) + 4 ), "%s/%s_%d.%s", path_ptr, filename, fw_data.fw_version, FILE_EXTENSION ) ;

  aio_data->filename = filename_ptr ;

  sysFsChmod ( filename_ptr, 0170777 ) ;
  sysFsUnlink ( filename_ptr ) ;

  if ( ( ret = aioutilOpen ( aio_data ) ) != 0 )
  {
    errprintf ( "file could not be opened: %s (%p), 0x%x", filename_ptr, filename_ptr, ret );
    goto error ;
  }
  else
  {
    argprintf ( "using path: %s (%p), filename: '%s (%p)'", path_ptr, path_ptr, filename_ptr, filename_ptr ) ;
  }

  if ( aio_data->buffered > 0 )
  {
    if ( ( aio_data->buf = malloc ( AIO_BUFFER ) ) == NULL )
    {
      errprintf ( "malloc buffer returned: %p", aio_data->buf ) ;
      goto error ;
    }
    else
    {
      memset ( aio_data->buf, 0, AIO_BUFFER ) ;
    }
  }

  return ( 0 ) ;

error:
  return ( -1 ) ;
}

s32
fileAioClose ( aioData *aio_data )
{
  s32 ret = -1 ;

  if ( ( ret = aioutilClose ( aio_data ) ) != 0 )
  {
    errprintf ( "aioutilClose returned: 0x%x", ret );
  }

  if ( ( ret = aioutilFinish ( aio_data ) ) != 0 )
  {
    errprintf ( "aioutilFinish returned: 0x%x", ret );
  }

  sysFsChmod ( aio_data->filename, 0170777 ) ;

  if ( aio_data->path )
  {
    free ( aio_data->path ) ;
    aio_data->path = NULL ;
  }

  if ( aio_data->filename )
  {
    free ( aio_data->filename ) ;
    aio_data->filename = NULL ;
  }

  if ( aio_data->buffered > 0 && aio_data->buf )
  {
    free ( aio_data->buf ) ;
    aio_data->buf = NULL ;
    aio_data->buffered = 0 ;
  }

  return ( ret ) ;
}

s32
fileAioBuffered ( u64 size )
{
  s32 ret = -1 ;

  if ( size > AIO_BUFFER )
  {
    dbgprintf ( "buffered" ) ;
    ret = 1 ;
  }
  else
  {
    dbgprintf ( "not buffered" ) ;
    ret = 0 ;
  }

  return ( ret ) ;
}

s32
fileAioWrite ( void *buffer, s32 size, aioData *aio_data )
{
  s32 ret = -1 ;
  void *buftmp = NULL ;

  if ( aio_data->buffered == 0 )
  {
    if ( aio_data->buf )
    {
      buftmp = aio_data->buf ;
    }

    aio_data->buf = buffer ;
    aio_data->bufsize = size ;

    if ( ( ret = aioutilWrite ( aio_data ) ) != 0 )
    {
      errprintf ( "aioutilWrite returned: 0x%x", ret );
    }
    else
    {
      ret = aio_data->bufsize ;
    }

    aio_data->aio.offset += aio_data->bufsize ;

    memset ( aio_data->buf, 0, aio_data->bufsize ) ;

    aio_data->bufsize = 0 ;

    if ( buftmp )
    {
      aio_data->buf = buftmp ;
    }
  }
  else
  {
    memcpy ( (void*) aio_data->buf + aio_data->bufsize, (void*) buffer, size ) ;
    aio_data->bufsize += size ;

    if ( aio_data->bufsize == AIO_BUFFER )
    {
      if ( ( ret = aioutilWrite ( aio_data ) ) != 0 )
      {
        errprintf ( "aioutilWrite returned: 0x%x", ret );
      }
      else
      {
        ret = aio_data->bufsize ;
      }

      aio_data->aio.offset += aio_data->bufsize ;

      memset ( aio_data->buf, 0, AIO_BUFFER ) ;
      aio_data->bufsize = 0 ;
    }
    else
    {
      ret = 0 ;
    }
  }

  return ( ret ) ;
}

