#line 1 "source/dumpingSend.c"
/*
 * dumpingSend.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>

#include "common.h"
#include "debug.h"

#include "eventutil.h"
#include "dumping.h"


/*
 * defines
 */


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* signal dump is completed */
void
dumpingSendMainUpdate ( dumpData *d_data )
{
  if ( *d_data->img_port > 0 )
  {
    eventutilSendPort ( d_data->img_port, d_data->row, IMAGE_UPDATE_MAIN, 0 ) ;
  }
}

/* signal a page is completed */
void
dumpingSendDumpUpdate ( dumpData *d_data )
{
  if ( *d_data->img_port > 0 )
  {
    eventutilSendPort ( d_data->img_port, d_data->row, IMAGE_UPDATE_DUMP, 0 ) ;
  }
}

/* memory LED value */
void
dumpingSendMemoryLed ( s32 value, dumpData *d_data )
{
  *d_data->dipswitch = value ;
  *d_data->memleds = value ;

  if ( *d_data->img_port > 0 )
  {
    eventutilSendPort ( d_data->img_port, *d_data->memleds, IMAGE_UPDATE_MEMLED, value ) ;
  }
}

/* memory LED value */
void
dumpingSendIoLed ( s32 value, dumpData *d_data )
{
  *d_data->ioleds = value ;

  if ( *d_data->img_port > 0 )
  {
    eventutilSendPort ( d_data->img_port, *d_data->ioleds, IMAGE_UPDATE_IOLED, value ) ;
  }
}

/* progress LED value */
void
dumpingSendProgressLed ( s32 value, dumpData *d_data )
{
  *d_data->progleds = value ;

  if ( *d_data->img_port > 0 )
  {
    eventutilSendPort ( d_data->img_port, *d_data->progleds, IMAGE_UPDATE_PROGLED, value ) ;
  }
}

