#line 1 "source/dump_idps.c"
/*
 * dump_idps.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <inttypes.h>
#include <time.h>

#include <ppu_intrinsics.h>

#include <sys/time.h>

#include "common.h"
#include "debug.h"

#include "patchutil.h"

#include "dumping.h"
#include "idps.h"
#include "hexdump.h"
#include "file.h"


/*
 * defines
 */


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* dump IDPS */
s32
dump_idps ( s32 store, const char *filename, dumpData *d_data )
{
  aioData aio_data ;
  s32 ret = 0 ;
  u8 *usr_buffer_ptr = NULL ;
  u64 size = DUMP_IDPS_SIZE ;

  imageBitmap *page_bitmap_ptr = (imageBitmap*) d_data->page_bitmap_ptr[0] ;
  argprintf ( "page_bitmap_ptr: %p, page_bitmap_ptr->ptr: %p", page_bitmap_ptr, page_bitmap_ptr->ptr ) ;

  imageBitmap *buffer_bitmap_ptr = (imageBitmap*) d_data->buffer_bitmap_ptr ;
  argprintf ( "buffer_bitmap_ptr: %p, buffer_bitmap_ptr->ptr: %p", buffer_bitmap_ptr, buffer_bitmap_ptr->ptr ) ;

  dbgprintf ( "dumping idps" ) ;

  usr_buffer_ptr = malloc ( size ) ;

  aio_data.buffered = fileAioBuffered ( size ) ;

  if ( ( ret = fileAioOpen ( store, filename, &aio_data ) ) != 0 )
  {
    errprintf ( "opening dump file: %s", filename ) ;
    goto done ;
  }

  memset ( usr_buffer_ptr, 0, size ) ;

  /* get IDPS */
  if ( ( ret = idps_get_via_console_id ( usr_buffer_ptr ) ) != 0 )
  {
    errprintf ( "IDPS idps_get_via_console_id returned: 0x%x", ret ) ;
    if ( ( ret = idps_get_via_aim ( usr_buffer_ptr ) ) != 0 )
    {
      errprintf ( "IDPS idps_get_via_aim returned: 0x%x", ret ) ;
      if ( ( ret = idps_get_via_indi ( usr_buffer_ptr ) ) != 0 )
      {
        errprintf ( "IDPS idps_get_via_indi returned: 0x%x", ret ) ;
        goto done ;
      }
    }
  }

  memset ( page_bitmap_ptr->ptr, 0, PAGE_SIZE ) ;
  memcpy ( page_bitmap_ptr->ptr, usr_buffer_ptr, size ) ;

  /* copy page data into buffer */
  videoutilImageCopy ( page_bitmap_ptr->offset,
                       page_bitmap_ptr->pitch,
                       buffer_bitmap_ptr->offset,
                       buffer_bitmap_ptr->pitch,
                       PAGE_SIZE,
                       1,
                       d_data->vu_data ) ;

  /* send buffer update event */
  dumpingSendDumpUpdate ( d_data ) ;

  argprintf ( "IDPS: %02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
              usr_buffer_ptr[0], usr_buffer_ptr[1], usr_buffer_ptr[2], usr_buffer_ptr[3],
              usr_buffer_ptr[4], usr_buffer_ptr[5], usr_buffer_ptr[6], usr_buffer_ptr[7],
              usr_buffer_ptr[8], usr_buffer_ptr[9], usr_buffer_ptr[10], usr_buffer_ptr[11],
              usr_buffer_ptr[12], usr_buffer_ptr[13], usr_buffer_ptr[14], usr_buffer_ptr[15] ) ;

  if ( ( ret = fileAioWrite ( usr_buffer_ptr, size, &aio_data ) ) < 0 )
  {
    errprintf("write failed (0x%08x)", ret);
    goto done;
  }

  ret = 0 ;

done:
  fileAioClose ( &aio_data ) ;

  if ( usr_buffer_ptr )
  {
    free ( usr_buffer_ptr ) ;
  }

  dbgprintf ( "dumped idps" ) ;

  return ( ret ) ;
}

