#line 1 "source/dump_functions.c"
/*
 * dump_functions.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <inttypes.h>

#include "common.h"
#include "debug.h"
#include "hexdump.h"
#include "patchutil.h"

#include "dump_flash.h"
#include "dump_eEID.h"
#include "dump_idps.h"
#include "dump_memory.h"
#include "dump_repo.h"
#include "copy_memory.h"
#include "map_memory.h"
#include "vflash.h"
#include "write_flash.h"


/*
 * defines
 */


/*
 * globals
 */

extern fwVersions fw_data ;
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* dump idps */
s32
dumpingIdps ( dumpData *d_data )
{
  s32 ret = -1 ;

  /* dump in prgress */
  *d_data->dumped = 0 ;

  if ( ( ret = dump_idps ( STORE_USB, DUMP_IDPS_FILENAME, d_data ) ) != 0 )
  {
    errprintf ( "IDPS dump returned: 0x%x (%d)", ret, ret ) ;
  }

  /* dump complete */
  *d_data->dumped = 1 ;
  *d_data->dipswitch = 0 ;
  *d_data->memleds = 0 ;
  *d_data->ioleds = 0 ;
  *d_data->progleds = 0 ;
  dumpingSendProgressLed ( DUMP_LED_NONE, d_data ) ;

  return ( ret ) ;
}

/* lv1 dump */
s32
dumpingLv1 ( dumpData *d_data )
{
  s32 ret = -1 ;

  /* dump in prgress */
  *d_data->dumped = 0 ;

  if ( ( ret = dump_memory ( TYPE_LV1, STORE_USB, DUMP_LV1_OFFSET, DUMP_LV1_SIZE, DUMP_LV1_FILENAME, d_data ) ) != 0 )
  { 
    errprintf ( "LV1 dump returned: 0x%x (%d)", ret, ret ) ;
  }

/*
  if ( ( ret = copy_memory ( TYPE_LV1, STORE_USB, DUMP_LV1_OFFSET, DUMP_LV1_SIZE, COPY_LV1_FILENAME, d_data ) ) != 0 )
  {
    errprintf ( "LV1 copy returned: 0x%x (%d)", ret, ret ) ;
  }
*/

  /* dump complete */
  *d_data->dumped = 1 ;
  *d_data->dipswitch = 0 ;
  *d_data->memleds = 0 ;
  *d_data->ioleds = 0 ;
  *d_data->progleds = 0 ;
  dumpingSendProgressLed ( DUMP_LED_NONE, d_data ) ;

  return ( ret ) ;
}

/* lv2 dump */
s32
dumpingLv2 ( dumpData *d_data )
{
  s32 ret = -1 ;

  /* dump in prgress */
  *d_data->dumped = 0 ;

  if ( ( ret = dump_memory ( TYPE_LV2, STORE_USB, DUMP_LV2_OFFSET, DUMP_LV2_SIZE, DUMP_LV2_FILENAME, d_data ) ) != 0 )
  {
    errprintf ( "LV2 dump returned: 0x%x (%d)", ret, ret ) ;
  }

/*
  if ( ( ret = copy_memory ( TYPE_LV2, STORE_USB, DUMP_LV2_OFFSET, DUMP_LV2_SIZE, COPY_LV2_FILENAME, d_data ) ) != 0 )
  {
    errprintf ( "LV2 copy returned: 0x%x (%d)", ret, ret ) ;
  }
*/

  /* dump complete */
  *d_data->dumped = 1 ;
  *d_data->dipswitch = 0 ;
  *d_data->memleds = 0 ;
  *d_data->ioleds = 0 ;
  *d_data->progleds = 0 ;
  dumpingSendProgressLed ( DUMP_LED_NONE, d_data ) ;

  return ( ret ) ;
}

s32
dumpingFlash ( dumpData *d_data )
{
  s32 ret = -1 ;

  /* dump in prgress */
  *d_data->dumped = 0 ;

  if ( ( ret = dump_flash ( STORE_USB, DUMP_FLASH_FILENAME, d_data ) ) != 0 )
  {
    errprintf ( "FLASH dump returned: 0x%x (%d)", ret, ret ) ;
  }

  /* dump complete */
  *d_data->dumped = 1 ;
  *d_data->dipswitch = 0 ;
  *d_data->memleds = 0 ;
  *d_data->ioleds = 0 ;
  *d_data->progleds = 0 ;

  return ( ret ) ;
}

s32
dumpingeEID ( dumpData *d_data )
{
  s32 ret = -1 ;

  /* dump in prgress */
  *d_data->dumped = 0 ;

  if ( ( ret = dump_eEID ( STORE_USB, DUMP_eEID_FILENAME, d_data ) ) != 0 )
  {
    errprintf ( "eEID dump returned: 0x%x (%d)", ret, ret ) ;
  }

  /* dump complete */
  *d_data->dumped = 1 ;
  *d_data->dipswitch = 0 ;
  *d_data->memleds = 0 ;
  *d_data->ioleds = 0 ;
  *d_data->progleds = 0 ;

  return ( ret ) ;
}

s32
dumping ( dumpData *d_data )
{
  s32 ret = -1 ;

  /* dump in prgress */
  *d_data->dumped = 0 ;


  /* dump complete */
  *d_data->dumped = 1 ;
  *d_data->dipswitch = 0 ;
  *d_data->memleds = 0 ;
  *d_data->ioleds = 0 ;
  *d_data->progleds = 0 ;

  return ( ret ) ;
}

