#line 0 "source/dipswitch_data.c"
/*
 * dipswitch_data.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>

#include "common.h"
#include "debug.h"
#include "imageutil.h"
#include "tilesetutil.h"
#include "dipswitch.h"


/*
 * defines
 */


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* png image data */
void
dipswitchDataInitialization ( void *d_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;
  void *tmp = NULL ;

  dipswitchData *dipswitch_data = (dipswitchData*)d_data ;

  dbgprintf ( "initializing" ) ;

  dipswitch_data->objects = DIP_OBJECTS ;
  dipswitch_data->states = DIP_STATES ;
  dipswitch_data->width = 35 ;
  dipswitch_data->height = 28 ;
  dipswitch_data->chromakey = CHROMAKEY ;

  /* allocate memory for tile object pointers */
  if ( ( tmp = calloc ( dipswitch_data->objects, sizeof ( tileBitmapData* ) ) ) != NULL )
  {
    dipswitch_data->tile = (tileBitmapData**) tmp ;
  }
  else
  {
    errprintf ( "ERROR: calloc() returned: %p", tmp ) ;
  }

  /* allocate object / state data memory */
  for ( i = 0; i < dipswitch_data->objects; i++ )
  {
    /* allocate memory for tile object/state data */
    if ( ( tmp = calloc ( dipswitch_data->states, sizeof ( tileBitmapData ) ) ) != NULL )
    {
      dipswitch_data->tile[i] = (tileBitmapData*) tmp ;
    }
    else
    {
      errprintf ( "ERROR: object: %d, calloc() returned: %p", i, tmp ) ;
    }
  }

  /* 0 */
  dipswitch_data->tile[DIP_NONE][DIP_OFF].minx = 1 ;
  dipswitch_data->tile[DIP_NONE][DIP_OFF].miny = 1 ;

  dipswitch_data->tile[DIP_NONE][DIP_ON].minx = 18 ;
  dipswitch_data->tile[DIP_NONE][DIP_ON].miny = 1 ;

  /* 1 */
  dipswitch_data->tile[DIP_ONE][DIP_OFF].minx = 1 ;
  dipswitch_data->tile[DIP_ONE][DIP_OFF].miny = 10 ;

  dipswitch_data->tile[DIP_ONE][DIP_ON].minx = 18 ;
  dipswitch_data->tile[DIP_ONE][DIP_ON].miny = 10 ;

  /* 2 */
  dipswitch_data->tile[DIP_TWO][DIP_OFF].minx = 1 ;
  dipswitch_data->tile[DIP_TWO][DIP_OFF].miny = 19 ;

  dipswitch_data->tile[DIP_TWO][DIP_ON].minx = 18 ;
  dipswitch_data->tile[DIP_TWO][DIP_ON].miny = 19 ;

  for ( i = 0; i < dipswitch_data->objects; i++ )
  {
    for ( j = 0; j < dipswitch_data->states; j++ )
    {
      dipswitch_data->tile[i][j].object = i ;
      dipswitch_data->tile[i][j].state = j ;
      dipswitch_data->tile[i][j].width = DIP_WIDTH ;
      dipswitch_data->tile[i][j].height = DIP_HEIGHT ;
      dipswitch_data->tile[i][j].pitch = 0;
      dipswitch_data->tile[i][j].length = 0;
      dipswitch_data->tile[i][j].chromakey = CHROMAKEY;
      dipswitch_data->tile[i][j].offset = 0;
      dipswitch_data->tile[i][j].ptr = NULL;
    }
  }

  dbgprintf ( "initialized" ) ;
}

