#line 0 "source/dipswitch.c"
/*
 * dipswitch.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "debug.h"
#include "videoutil.h"
#include "tilesetutil.h"

#include "dipswitch.h"


/*
 * defines
 */


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* initialize dipswitch for use */
void
dipswitchInitialization ( void *d_data )
{
  dbgprintf ( "initializing" ) ;

  /* initialize dipswitch tileset */
  tilesetutilInitialization ( d_data ) ;

  /* initialize dipswitch data */
  dipswitchDataInitialization ( d_data ) ;

  /* load dipswitch tileset bitmap */
  dipswitchLoadTileset ( (void*)tileset_dipswitch_png, tileset_dipswitch_png_size, d_data ) ;

  /* load each tile bitmap from tileset bitmap */
  dipswitchLoadTiles ( d_data ) ;

  dbgprintf ( "initialized" ) ;
}

/* cleanup memory */
void
dipswitchFinish ( void *d_data )
{
  dbgprintf ( "finishing" ) ;

  tilesetutilFinish ( d_data ) ;

  dbgprintf ( "finished" ) ;
}

/* clear text buffer */
void
dipswitchBufferClear ( void *d_data )
{
  tilesetutilBufferClear ( 0x00, d_data ) ;
}

/* load tileset bitmap */
void
dipswitchLoadTileset ( void *mem, u32 size, void *d_data )
{
  tilesetutilLoadTilesetBitmapFromMemory ( mem, size, d_data ) ;
}

/* load dip tile bitmap from tileset bitmap */
void
dipswitchLoadTiles ( void *d_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;

  /* load each dip tile from tileset */
  for ( i = 0 ; i < DIP_OBJECTS; i++ )
  {
    for ( j = 0 ; j < DIP_STATES; j++ )
    {
      /* load dip bitmap from tileset bitmap */
      tilesetutilLoadTileFromTileset ( (u8) i, (u8) j, d_data ) ;
    }
  }
}

/* draw dip tile into buffer */
void
dipDraw ( u8 object, u8 state, u8 from, s32 x, s32 y, void *vu_data )
{
  videoutilTileBufferDrawBlend ( object, state, from, x, y, vu_data ) ;
}

