#line 0 "source/digits_data.c"
/*
 * digits_data.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>

#include "common.h"
#include "debug.h"
#include "imageutil.h"
#include "tilesetutil.h"
#include "digits.h"


/*
 * defines
 */


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* png image data */
void
digitsDataInitialization ( void *d_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;
  void *tmp = NULL ;

  digitsData *digits_data = (digitsData*)d_data ;

  dbgprintf ( "initializing" ) ;

  digits_data->objects = DIGIT_OBJECTS ;
  digits_data->states = DIGIT_STATES ;
  digits_data->width = 124 ;
  digits_data->height = 611 ;
  digits_data->chromakey = CHROMAKEY ;

  /* allocate memory for tile object pointers */
  if ( ( tmp = calloc ( digits_data->objects, sizeof ( tileBitmapData* ) ) ) != NULL )
  {
    digits_data->tile = (tileBitmapData**) tmp ;
  }
  else
  {
    errprintf ( "ERROR: calloc() returned: %p", tmp ) ;
  }

  /* allocate object / state data memory */
  for ( i = 0; i < digits_data->objects; i++ )
  {
    /* allocate memory for tile object/state data */
    if ( ( tmp = calloc ( digits_data->states, sizeof ( tileBitmapData ) ) ) != NULL )
    {
      digits_data->tile[i] = (tileBitmapData*) tmp ;
    }
    else
    {
      errprintf ( "ERROR: object: %d, calloc() returned: %p", i, tmp ) ;
    }
  }

  /* 0 */
  digits_data->tile[DIGIT_ZERO][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_ZERO][DIGIT_OFF].miny = 1 ;

  digits_data->tile[DIGIT_ZERO][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_ZERO][DIGIT_NODOT].miny = 1 ;

  digits_data->tile[DIGIT_ZERO][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_ZERO][DIGIT_DOTON].miny = 1 ;

  /* 1 */
  digits_data->tile[DIGIT_ONE][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_ONE][DIGIT_OFF].miny = 62 ;

  digits_data->tile[DIGIT_ONE][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_ONE][DIGIT_NODOT].miny = 62 ;

  digits_data->tile[DIGIT_ONE][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_ONE][DIGIT_DOTON].miny = 62 ;

  /* 2 */
  digits_data->tile[DIGIT_TWO][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_TWO][DIGIT_OFF].miny = 123 ;

  digits_data->tile[DIGIT_TWO][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_TWO][DIGIT_NODOT].miny = 123 ;

  digits_data->tile[DIGIT_TWO][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_TWO][DIGIT_DOTON].miny = 123 ;

  /* 3 */
  digits_data->tile[DIGIT_THREE][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_THREE][DIGIT_OFF].miny = 184 ;

  digits_data->tile[DIGIT_THREE][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_THREE][DIGIT_NODOT].miny = 184 ;

  digits_data->tile[DIGIT_THREE][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_THREE][DIGIT_DOTON].miny = 184 ;

  /* 4 */
  digits_data->tile[DIGIT_FOUR][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_FOUR][DIGIT_OFF].miny = 245 ;

  digits_data->tile[DIGIT_FOUR][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_FOUR][DIGIT_NODOT].miny = 245 ;

  digits_data->tile[DIGIT_FOUR][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_FOUR][DIGIT_DOTON].miny = 245 ;

  /* 5 */
  digits_data->tile[DIGIT_FIVE][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_FIVE][DIGIT_OFF].miny = 306 ;

  digits_data->tile[DIGIT_FIVE][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_FIVE][DIGIT_NODOT].miny = 306 ;

  digits_data->tile[DIGIT_FIVE][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_FIVE][DIGIT_DOTON].miny = 306 ;

  /* 6 */
  digits_data->tile[DIGIT_SIX][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_SIX][DIGIT_OFF].miny = 367 ;

  digits_data->tile[DIGIT_SIX][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_SIX][DIGIT_NODOT].miny = 367 ;

  digits_data->tile[DIGIT_SIX][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_SIX][DIGIT_DOTON].miny = 367 ;

  /* 7 */
  digits_data->tile[DIGIT_SEVEN][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_SEVEN][DIGIT_OFF].miny = 428 ;

  digits_data->tile[DIGIT_SEVEN][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_SEVEN][DIGIT_NODOT].miny = 428 ;

  digits_data->tile[DIGIT_SEVEN][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_SEVEN][DIGIT_DOTON].miny = 428 ;

  /* 8 */
  digits_data->tile[DIGIT_EIGHT][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_EIGHT][DIGIT_OFF].miny = 489 ;

  digits_data->tile[DIGIT_EIGHT][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_EIGHT][DIGIT_NODOT].miny = 489 ;

  digits_data->tile[DIGIT_EIGHT][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_EIGHT][DIGIT_DOTON].miny = 489 ;

  /* 9 */
  digits_data->tile[DIGIT_NINE][DIGIT_OFF].minx = 1 ;
  digits_data->tile[DIGIT_NINE][DIGIT_OFF].miny = 550 ;

  digits_data->tile[DIGIT_NINE][DIGIT_NODOT].minx = 42 ;
  digits_data->tile[DIGIT_NINE][DIGIT_NODOT].miny = 550 ;

  digits_data->tile[DIGIT_NINE][DIGIT_DOTON].minx = 83 ;
  digits_data->tile[DIGIT_NINE][DIGIT_DOTON].miny = 550 ;

  /* init values */
  for ( i = 0; i < digits_data->objects; i++ )
  {
    for ( j = 0; j < digits_data->states; j++ )
    {
      digits_data->tile[i][j].object = i ;
      digits_data->tile[i][j].state = j ;
      digits_data->tile[i][j].width = DIGIT_WIDTH ;
      digits_data->tile[i][j].height = DIGIT_HEIGHT ;
      digits_data->tile[i][j].pitch = 0;
      digits_data->tile[i][j].length = 0;
      digits_data->tile[i][j].chromakey = CHROMAKEY;
      digits_data->tile[i][j].offset = 0;
      digits_data->tile[i][j].ptr = NULL;
    }
  }

  dbgprintf ( "initialized" ) ;
}

