#line 0 "source/digits.c"
/*
 * digits.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "debug.h"
#include "videoutil.h"
#include "tilesetutil.h"

#include "digits.h"


/*
 * defines
 */


/*
 * globals
 */

extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* initialize digits for use */
void
digitsInitialization ( void *d_data )
{
  dbgprintf ( "initializing" ) ;

  /* initialize digits tileset */
  tilesetutilInitialization ( d_data ) ;

  /* initialize digits data */
  digitsDataInitialization ( d_data ) ;

  /* load digits tileset bitmap */
  digitsLoadTileset ( (void*)tileset_digits_png, tileset_digits_png_size, d_data ) ;

  /* load each tile bitmap from tileset bitmap */
  digitsLoadTiles ( d_data ) ;

  dbgprintf ( "initialized" ) ;
}

/* cleanup memory */
void
digitsFinish ( void *d_data )
{
  dbgprintf ( "finishing" ) ;

  tilesetutilFinish ( d_data ) ;

  dbgprintf ( "finished" ) ;
}

/* clear text buffer */
void
digitsBufferClear ( void *d_data )
{
  tilesetutilBufferClear ( 0x00, d_data ) ;
}

/* load tileset bitmap */
void
digitsLoadTileset ( void *mem, u32 size, void *d_data )
{
  tilesetutilLoadTilesetBitmapFromMemory ( mem, size, d_data ) ;
}

/* load digit tile bitmap from tileset bitmap */
void
digitsLoadTiles ( void *d_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;

  /* load each digit tile from tileset */
  for ( i = 0 ; i < DIGIT_OBJECTS; i++ )
  {
    for ( j = 0 ; j < DIGIT_STATES; j++ )
    {
      /* load digit bitmap from tileset bitmap */
      tilesetutilLoadTileFromTileset ( (u8) i, (u8) j, d_data ) ;
    }
  }
}

/* draw digit tile into buffer */
void
digitDraw ( u8 object, u8 state, u8 from, s32 x, s32 y, void *vu_data )
{
  videoutilTileBufferDrawBlend ( object, state, from, x, y, vu_data ) ;
}

