#line 0 "source/buttons_data.c"
/*
 * buttons_data.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>

#include "common.h"
#include "debug.h"
#include "imageutil.h"
#include "tilesetutil.h"
#include "buttons.h"


/*
 * defines
 */


/*
 * globals
 */
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* png image data */
void
buttonsDataInitialization ( void *b_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;
  void *tmp = NULL ;

  buttonsData *buttons_data = (buttonsData*)b_data ;

  dbgprintf ( "initializing" ) ;

  buttons_data->objects = BUTTON_OBJECTS ;
  buttons_data->states = BUTTON_STATES ;
  buttons_data->width = 63 ;
  buttons_data->height = 156 ;
  buttons_data->chromakey = CHROMAKEY ;

  /* allocate memory for tile object pointers */
  if ( ( tmp = calloc ( buttons_data->objects, sizeof ( tileBitmapData* ) ) ) != NULL )
  {
    buttons_data->tile = (tileBitmapData**) tmp ;
  }
  else
  {
    errprintf ( "ERROR: calloc() returned: %p", tmp ) ;
  }

  /* allocate object / state data memory */
  for ( i = 0; i < buttons_data->objects; i++ )
  {
    /* allocate memory for tile object/state data */
    if ( ( tmp = calloc ( buttons_data->states, sizeof ( tileBitmapData ) ) ) != NULL )
    {
      buttons_data->tile[i] = (tileBitmapData*) tmp ;
    }
    else
    {
      errprintf ( "ERROR: object: %d, calloc() returned: %p", i, tmp ) ;
    }
  }

  /* NONE */
  buttons_data->tile[BUTTON_NONE][BUTTON_UP].minx = 1;
  buttons_data->tile[BUTTON_NONE][BUTTON_UP].miny = 1;

  buttons_data->tile[BUTTON_NONE][BUTTON_DOWN].minx = 1;
  buttons_data->tile[BUTTON_NONE][BUTTON_DOWN].miny = 1;
  
  /* △  triangle */
  buttons_data->tile[BUTTON_TRIANGLE][BUTTON_UP].minx = 1;
  buttons_data->tile[BUTTON_TRIANGLE][BUTTON_UP].miny = 32;

  buttons_data->tile[BUTTON_TRIANGLE][BUTTON_DOWN].minx = 32;
  buttons_data->tile[BUTTON_TRIANGLE][BUTTON_DOWN].miny = 32;

  /* ◯  circle */
  buttons_data->tile[BUTTON_CIRCLE][BUTTON_UP].minx = 1;
  buttons_data->tile[BUTTON_CIRCLE][BUTTON_UP].miny = 63;

  buttons_data->tile[BUTTON_CIRCLE][BUTTON_DOWN].minx = 32;
  buttons_data->tile[BUTTON_CIRCLE][BUTTON_DOWN].miny = 63;

  /* ✕  cross */
  buttons_data->tile[BUTTON_CROSS][BUTTON_UP].minx = 1;
  buttons_data->tile[BUTTON_CROSS][BUTTON_UP].miny = 94;

  buttons_data->tile[BUTTON_CROSS][BUTTON_DOWN].minx = 32;
  buttons_data->tile[BUTTON_CROSS][BUTTON_DOWN].miny = 94;

  /* ☐  square */
  buttons_data->tile[BUTTON_SQUARE][BUTTON_UP].minx = 1;
  buttons_data->tile[BUTTON_SQUARE][BUTTON_UP].miny = 125;

  buttons_data->tile[BUTTON_SQUARE][BUTTON_DOWN].minx = 32;
  buttons_data->tile[BUTTON_SQUARE][BUTTON_DOWN].miny = 125;

  /* load data */
  for ( i = 0; i < buttons_data->objects; i++ )
  {
    for ( j = 0; j < buttons_data->states; j++ )
    {
      buttons_data->tile[i][j].object = i ;
      buttons_data->tile[i][j].state = j ;
      buttons_data->tile[i][j].width = BUTTON_WIDTH ;
      buttons_data->tile[i][j].height = BUTTON_HEIGHT ;
      buttons_data->tile[i][j].pitch = 0;
      buttons_data->tile[i][j].length = 0;
      buttons_data->tile[i][j].chromakey = CHROMAKEY;
      buttons_data->tile[i][j].offset = 0;
      buttons_data->tile[i][j].ptr = NULL;
    }
  }

  dbgprintf ( "initialized" ) ;
}

