#line 0 "source/buttons.c"
/*
 * buttons.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include <stdio.h>
#include <string.h>

#include "common.h"
#include "debug.h"
#include "videoutil.h"
#include "tilesetutil.h"

#include "buttons.h"


/*
 * defines
 */


/*
 * globals
 */
extern u32 log_fd ;
extern char string[MAX_STRING] ;


/*
 * functions
 */

/* initialize buttons for use */
void
buttonsInitialization ( void *b_data )
{
  dbgprintf ( "initializing" ) ;

  /* initialize buttons tileset */
  tilesetutilInitialization ( b_data ) ;

  /* initialize buttons data */
  buttonsDataInitialization ( b_data ) ;

  /* load buttons tileset bitmap */
  buttonsLoadTileset ( (void*)tileset_buttons_png, tileset_buttons_png_size, b_data ) ;

  /* load each tile bitmap from tileset bitmap */
  buttonsLoadTiles ( b_data ) ;

  dbgprintf ( "initialized" ) ;
}

/* cleanup memory */
void
buttonsFinish ( void *b_data )
{
  dbgprintf ( "finishing" ) ;

  tilesetutilFinish ( b_data ) ;

  dbgprintf ( "finished" ) ;
}

/* clear text buffer */
void
buttonsBufferClear ( void *b_data )
{
  tilesetutilBufferClear ( 0x00, b_data ) ;
}

/* load tileset bitmap */
void
buttonsLoadTileset ( void *mem, u32 size, void *b_data )
{
  tilesetutilLoadTilesetBitmapFromMemory ( mem, size, b_data ) ;
}

/* load button tile bitmap from tileset bitmap */
void
buttonsLoadTiles ( void *b_data )
{
  static s32 i = 0 ;
  static s32 j = 0 ;

  /* load each button tile from tileset */
  for ( i = 0 ; i < BUTTON_OBJECTS; i++ )
  {
    for ( j = 0 ; j < BUTTON_STATES; j++ )
    {
      /* load button bitmap from tileset bitmap */
      tilesetutilLoadTileFromTileset ( (u8) i, (u8) j, b_data ) ;
    }
  }
}

/* draw button tile into buffer */
void
buttonDraw ( u8 object, u8 state, u8 from, s32 x, s32 y, void *vu_data )
{
  videoutilTileBufferDrawBlend ( object, state, from, x, y, vu_data ) ;
}

