#line 1 "source/beep.c"
/*
 * beep.c
 *
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 *
 */

/*
 * includes
 */

#include "patchutil.h"


/*
 * defines
 */

#define MMIO_BASE           0x24000000000ULL
#define SYSCON_PACKET       ( MMIO_BASE | 0x8D000ULL )
#define SYSCON_PACKET_CTR   ( MMIO_BASE | 0x8DFF0ULL )
#define SYSCON_PACKET_KICK  ( MMIO_BASE | 0x8E100ULL )


/*
 * functions
 */

s32
beep_triple ()
{
  /* packet counter */
  u32 counter = hvcall_lv1_peek32 ( SYSCON_PACKET_CTR ) ;
  u32 packet_ctr = ((((counter >> 16) + 1) << 16) + ((counter >> 16) + 1));
  hvcall_lv1_poke32 ( SYSCON_PACKET_CTR, packet_ctr ) ;

  /* write packet */
  hvcall_lv1_poke ( SYSCON_PACKET + 0,  0x160116200000804d ) ;
  hvcall_lv1_poke ( SYSCON_PACKET + 8,  0x0000000100080008 ) ;
  hvcall_lv1_poke ( SYSCON_PACKET + 16, 0x20290a00000001b6 ) ;
  hvcall_lv1_poke ( SYSCON_PACKET + 24, 0x0000fdcb00000000 ) ;

  /* kick packet */
  hvcall_lv1_poke32 ( SYSCON_PACKET_KICK, 0x00000001 ) ;

  return ( 0 ) ;
}

