/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __VIDEOUTIL_H__
#define __VIDEOUTIL_H__


#include "common.h"
#include "eventutil.h"


typedef struct _videoutil_data
{
  u16 *width;
  u16 *height;

  s32 *exitapp;

  sys_mutex_t mutex;
  sys_mutex_attr_t mutex_attr;

  sys_lwmutex_t lwmutex;
  sys_lwmutex_attr_t lwmutex_attr;

  sys_cond_t cond;
  sys_cond_attr_t cond_attr;

  sys_ppu_thread_t ppu_thread;

  void *context;

  void *event_data;
  void *image_data;
  void *tileset_data;
  void *font_data;
  void *resc_data;

  void *image_buffer;
  void *tileset_buffer;
  void *font_buffer;
  void *resc_buffer;

  void *video_data;
} videoutilData;


void videoutilInitialization(videoutilData *vu_data, eventData *e_data, u64 *priority);
void videoutilFinish(videoutilData *vu_data);

void videoutilBufferClear(videoutilData *vu_data);
void videoutilBufferDraw(videoutilData *vu_data);
void videoutilWaitFlip();
void videoutilFlip(videoutilData *vu_data);

void videoutilImageLoadPngFromMemory(u8 index, void *buf, u32 size, videoutilData *vu_data);
void videoutilImageLoadPngFromFile(u8 index, const char *filename, videoutilData *vu_data);
void videoutilImageLoadJpgFromMemory(u8 index, void *buf, u32 size, videoutilData *vu_data);
void videoutilImageLoadJpgFromFile(u8 index, const char *filename, videoutilData *vu_data);
void videoutilImageGetPointer(u8 index, void **ptr, videoutilData *vu_data);

void videoutilImageCopy(u32 src_offset, u32 src_pitch, u32 dst_offset, u32 dst_pitch, u32 size, u32 rows, videoutilData *vu_data);
void videoutilImageBufferClear(videoutilData *vu_data);
void videoutilImageBufferDraw(u8 index, u8 from, s32 x, s32 y, videoutilData *vu_data);
void videoutilImageBufferDrawBlend(u8 index, u8 from, s32 x, s32 y, videoutilData *vu_data);
void videoutilImageBufferDrawScaled(u8 index, u8 from, s32 x, s32 y, float zoom, videoutilData *vu_data);
void videoutilImageBufferDrawScaledBlend(u8 index, u8 from, s32 x, s32 y, float zoom, videoutilData *vu_data);
void videoutilImageFinish(videoutilData *vu_data);

void videoutilFontBufferClear(videoutilData *vu_data);
void videoutilFontBufferPrint(u8 index, s32 x, s32 y, char *string, videoutilData *vu_data);

void videoutilTileBufferClear(videoutilData *vu_data);
void videoutilTileBufferDraw(u8 index, u8 state, u8 from, s32 x, s32 y, videoutilData *vu_data);
void videoutilTileBufferDrawBlend(u8 index, u8 state, u8 from, s32 x, s32 y, videoutilData *vu_data);


#endif /* __VIDEOUTIL_H__ */

