/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __TILESETUTIL_H__
#define __TILESETUTIL_H__

#include <ppu-types.h>

#include "common.h"
#include "imageutil.h"


typedef imageBitmap tilesetBitmap;
typedef imageBuffer tilesetBuffer;

typedef struct _tile_bitmap_data
{
  u8 object;
  u8 state;
  u32 minx;
  u32 miny;
  u32 width;
  u32 height;
  u32 pitch;
  u32 length;
  u32 chromakey;
  u32 x;
  u32 y;
  u32 offset;
  u32 *ptr;
} tileBitmapData;

typedef struct _tileset_data
{
  u8 num;
  u8 objects;
  u8 states;
  u32 width;
  u32 height;
  u32 length;
  u32 chromakey;
  tilesetBitmap tileset_bitmap;
  tilesetBuffer *tileset_buffer;
  tileBitmapData **tile;
} tilesetData;


/* tileset functions */
void tilesetutilInitialization(void *ts_data);
void tilesetutilDataInitialization(void *ts_data);

void tilesetutilFinish(void *ts_data);

void tilesetutilBufferClear(u8 value, void *ts_data);

/* load tileset */
void tilesetutilLoadTilesetBitmapFromFile(const char *filename, void *ts_data);
void tilesetutilLoadTilesetBitmapFromMemory(void *mem, u32 size, void *ts_data);

/* load tile */
void tilesetutilLoadTileFromTileset(u8 object, u8 state, void *ts_data);

/* draw tile */
void tilesetutilDrawTile(u8 object, u8 state, u8 blend, u8 from, u32 x, u32 y, void *ctx, void *ts_data);
void tilesetutilDrawTileScaled(u8 object, u8 state, u8 blend, float scale, u8 from, u32 x, u32 y, void *ctx, void *ts_data);


#endif /* __TILESETUTIL_H__ */

