/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */


#ifndef __SYNCUTIL_H__
#define __SYNCUTIL_H__

#include <ppu-types.h>

#include <sys/sem.h>
#include <sys/cond.h>
#include <sys/mutex.h>
#include <sys/rwlock.h>
#include <sys/event_flag.h>
#include <sys/timer.h>
#include <sys/spinlock.h>
#include <sys/thread.h>


s32 syncutilSemCreate(sys_sem_t *sem, const sys_sem_attr_t *attr, s32 val, s32 max_val);
s32 syncutilSemDestroy(sys_sem_t *sem);
s32 syncutilSemWait(sys_sem_t *sem, u64 timeout);
s32 syncutilSemTryWait(sys_sem_t *sem);
s32 syncutilSemPost(sys_sem_t *sem, s32 count);
s32 syncutilSemGetValue(sys_sem_t *sem, s32 *count);

s32 syncutilLwMutexCreate(sys_lwmutex_t *lwmutex, const sys_lwmutex_attr_t *attr);
s32 syncutilLwMutexDestroy(sys_lwmutex_t *lwmutex);
s32 syncutilLwMutexLock(sys_lwmutex_t *lwmutex, u64 timeout);
s32 syncutilLwMutexTryLock(sys_lwmutex_t *lwmutex);
s32 syncutilLwMutexUnlock(sys_lwmutex_t *lwmutex);

s32 syncutilMutexCreate(sys_mutex_t *mutex, const sys_mutex_attr_t *attr);
s32 syncutilMutexDestroy(sys_mutex_t *mutex);
s32 syncutilMutexLock(sys_mutex_t *mutex, u64 timeout);
s32 syncutilMutexTryLock(sys_mutex_t *mutex);
s32 syncutilMutexUnlock(sys_mutex_t *mutex);

s32 syncutilLwCondCreate(sys_lwcond_t *lwcond, sys_lwmutex_t *lwmutex, sys_lwcond_attr_t *attr);
s32 syncutilLwCondDestroy(sys_lwcond_t *lwcond);
s32 syncutilLwCondWait(sys_lwcond_t *lwcond, u64 timeout);
s32 syncutilLwCondSignal(sys_lwcond_t *lwcond);
s32 syncutilLwCondSignalTo(sys_lwcond_t *lwcond, sys_ppu_thread_t *thread);
s32 syncutilLwCondSignalAll(sys_lwcond_t *lwcond);

s32 syncutilCondCreate(sys_cond_t *cond, sys_mutex_t *mutex, const sys_cond_attr_t *attr);
s32 syncutilCondDestroy(sys_cond_t *cond);
s32 syncutilCondWait(sys_cond_t *cond, u64 timeout);
s32 syncutilCondSignal(sys_cond_t *cond);
s32 syncutilCondSignalTo(sys_cond_t *cond, sys_ppu_thread_t *thread);
s32 syncutilCondSignalAll(sys_cond_t *cond);

s32 syncutilRwLockCreate(sys_rwlock_t *rwlock, sys_rwlock_attr_t *attr);
s32 syncutilRwLockDestroy(sys_rwlock_t *rwlock);
s32 syncutilRwLockReadLock(sys_rwlock_t *rwlock, u64 timeout);
s32 syncutilRwLockTryReadLock(sys_rwlock_t *rwlock);
s32 syncutilRwLockReadUnlock(sys_rwlock_t *rwlock);
s32 syncutilRwLockWriteLock(sys_rwlock_t *rwlock, u64 timeout);
s32 syncutilRwLockTryWriteLock(sys_rwlock_t *rwlock);
s32 syncutilRwLockWriteUnlock(sys_rwlock_t *rwlock);

s32 syncutilEventFlagCreate(sys_event_flag_t *flag_id, sys_event_flag_attr_t *attr, u64 init);
s32 syncutilEventFlagDestroy(sys_event_flag_t *flag_id);
s32 syncutilEventFlagWait(sys_event_flag_t *flag_id, u64 bitptn, u32 mode, u64 *result, usecond_t timeout);
s32 syncutilEventFlagTryWait(sys_event_flag_t *flag_id, u64 bitptn, u32 mode, u64 *result);
s32 syncutilEventFlagSet(sys_event_flag_t *flag_id, u64 bitptn);
s32 syncutilEventFlagClear(sys_event_flag_t *flag_id, u64 bitptn);
s32 syncutilEventFlagCancel(sys_event_flag_t *flag_id, s32 *num);
s32 syncutilEventFlagGet(sys_event_flag_t *flag_id, u64 *bitptn);

s32 syncutilTimerCreate(sys_timer_t *timer_id);
s32 syncutilTimerDestroy(sys_timer_t *timer_id);
s32 syncutilTimerGetInformation(sys_timer_t *timer_id, sys_timer_information_t *info);
s32 syncutilTimerStart(sys_timer_t *timer_id, system_time_t *base_time, usecond_t *period);
s32 syncutilTimerStartOneShot(sys_timer_t *timer_id, system_time_t *expiration_time);
s32 syncutilTimerStartPeriodic(sys_timer_t *timer_id, usecond_t *period);
s32 syncutilTimerStartAbsolute(sys_timer_t *timer_id, system_time_t *expiration_time, usecond_t *period);
s32 syncutilTimerStop(sys_timer_t *timer_id);
s32 syncutilTimerConnectEventQueue(sys_timer_t *timer_id, sys_event_queue_t *queue_id, u64 *name, u64 *data1, u64 *data2);
s32 syncutilTimerDisconnectEventQueue(sys_timer_t *timer_id);

void syncutilSpinlockInit(s32 *lock);
void syncutilSpinlockLock(s32 *lock);
s32 syncutilSpinlockTryLock(s32 *lock);
void syncutilSpinlockUnlock(s32 *lock);

s32 syncutilWatchdogClear();
s32 syncutilWatchdogStart();
s32 syncutilWatchdogStop();


#endif /* __SYNCUTIL_H__ */

