/*
 * Copyright (C) an0nym0us
 *
 * This software is distributed under the terms of the GNU General Public
 * License ("GPL") version 3, as published by the Free Software Foundation.
 */

#ifndef __RESCUTIL_RESC_H__
#define __RESCUTIL_RESC_H__


#include <sysutil/video.h>
#include <gcm/resc.h>

#include "common.h"
#include "gcmutil.h"
#include "rescutil.h"

#define RESCUTIL_MAX_BUFFERS                  ( 1 )

#define RESCUTIL_BUFFER_WIDTH                 ( 1280 )
#define RESCUTIL_BUFFER_HEIGHT                ( 720 )

#define RESCUTIL_BUFFER_ID                    ( 0 )
#define RESCUTIL_PIXEL_BUFFER_ID              ( 1 )
#define RESCUTIL_SRC_BUFFER_ID                RESCUTIL_PIXEL_BUFFER_ID
#define RESCUTIL_COLOR_BUFFER_ID              ( 2 )
#define RESCUTIL_DST_BUFFER_ID                RESCUTIL_COLOR_BUFFER_ID

#define RESCUTIL_SRC_BUFFER_INDEX             ( 0 )

#define RESCUTIL_RESC_BUFFER_TILE_INDEX       ( 0 )
#define RESCUTIL_PIXEL_BUFFER_TILE_INDEX      ( 1 )
#define RESCUTIL_COLOR_BUFFER_TILE_INDEX      ( 2 )
#define RESCUTIL_DST_BUFFER_INDEX             RESCUTIL_COLOR_BUFFER_TILE_INDEX

#define RESCUTIL_CB_SIZE                      ( 0x100000 )
#define RESCUTIL_HOST_SIZE                    ( 32 * 1024 * 1024 )
#define RESCUTIL_GCM_LABEL_INDEX              ( 255 )

#define RESCUTIL_VIDEO_PRIMARY                ( 0 )
#define RESCUTIL_VIDEO_DEVICE_INDEX           ( 0 )
#define RESCUTIL_VIDEO_RES_UNDEFINED          ( 0 )

//#define RESCUTIL_COMPRESSION                  ( GCM_COMPMODE_DISABLED )
//#define RESCUTIL_COMPRESSION                  ( GCM_COMPMODE_C32_2X1 ) 
#define RESCUTIL_COMPRESSION                  ( GCM_COMPMODE_C32_2X2 ) 

/* 0.0 - 1.5 */
#define RESCUTIL_OVERSCAN_NONE                ( 1.000f )
#define RESCUTIL_OVERSCAN_HDMI                ( 1.000f )
#define RESCUTIL_OVERSCAN_NETWORK             ( 1.000f )
#define RESCUTIL_OVERSCAN_COMPOSITE           ( 1.070f )
#define RESCUTIL_OVERSCAN_D                   ( 1.000f )
#define RESCUTIL_OVERSCAN_COMPONENT           ( 1.055f )
#define RESCUTIL_OVERSCAN_RGB                 ( 1.000f )
#define RESCUTIL_OVERSCAN_SCART               ( 1.000f )
#define RESCUTIL_OVERSCAN_DSUB                ( 1.000f )

/* 0.5 - 2.0 */
#define RESCUTIL_HORIZONTAL_ASPECT            ( 2.000f )
#define RESCUTIL_VERTICAL_ASPECT              ( 2.000f )

#define RESCUTIL_HORIZONTAL_ASPECT_NONE       ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_NONE )
#define RESCUTIL_VERTICAL_ASPECT_NONE         ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_NONE )
#define RESCUTIL_HORIZONTAL_ASPECT_HDMI       ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_HDMI )
#define RESCUTIL_VERTICAL_ASPECT_HDMI         ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_HDMI )
#define RESCUTIL_HORIZONTAL_ASPECT_NETWORK    ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_NETWORK )
#define RESCUTIL_VERTICAL_ASPECT_NETWORK      ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_NETWORK )
#define RESCUTIL_HORIZONTAL_ASPECT_COMPOSITE  ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_COMPOSITE )
#define RESCUTIL_VERTICAL_ASPECT_COMPOSITE    ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_COMPOSITE )
#define RESCUTIL_HORIZONTAL_ASPECT_D          ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_D )
#define RESCUTIL_VERTICAL_ASPECT_D            ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_D )
#define RESCUTIL_HORIZONTAL_ASPECT_COMPONENT  ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_COMPONENT )
#define RESCUTIL_VERTICAL_ASPECT_COMPONENT    ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_COMPONENT )
#define RESCUTIL_HORIZONTAL_ASPECT_RGB        ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_RGB )
#define RESCUTIL_VERTICAL_ASPECT_RGB          ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_RGB )
#define RESCUTIL_HORIZONTAL_ASPECT_SCART      ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_SCART )
#define RESCUTIL_VERTICAL_ASPECT_SCART        ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_SCART )
#define RESCUTIL_HORIZONTAL_ASPECT_DSUB       ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_DSUB )
#define RESCUTIL_VERTICAL_ASPECT_DSUB         ( RESCUTIL_HORIZONTAL_ASPECT - RESCUTIL_OVERSCAN_DSUB )

#define RESCUTIL_FLEX_RATIO                   ( 0.0f )

#define RESCUTIL_CHROMAKEY                    0x00ffffff

#define RESCUTIL_COLOR_NONE                   -1
#define RESCUTIL_COLOR_BLACK                  0xff000000
#define RESCUTIL_COLOR_GREY                   0xff444444
#define RESCUTIL_COLOR_WHITE                  0xffffffff

#define RESCUTIL_COLOR_CLEAR                  RESCUTIL_COLOR_BLACK

#define RESCUTIL_TILED_MEMALIGN(size)     rescutilMemalign( GCM_TILE_ALIGN_OFFSET, size )


typedef gcmBuffer rescBuffer;

typedef enum _videoAspects
{
  ASPECT_AUTO           = VIDEO_ASPECT_AUTO,
  ASPECT_4_3            = VIDEO_ASPECT_4_3,
  ASPECT_16_9           = VIDEO_ASPECT_16_9 
} videoAspects;

typedef struct _vertex_buffer
{
  float x;
  float y;
  float z;
  u32 rgba;
} vertexBuffer;

typedef struct _vertex_array_buffer
{
  int id;
  int size;
  void *ptr;
  u32 offset;
  vertexBuffer *buf;
} vertexArrayBuffer;

typedef struct _fragment_shader_buffer
{
  int id;
  int size;
  void *ptr;
  u32 offset;
} fragmentShaderBuffer;

typedef struct _interlace_table
{
  s32 id;
  s32 size;
  void *ptr;
  u32 offset;
} interlaceTable;

typedef struct _resc_data
{
  u8 resc_pal;
  u8 resc_interlace;
  u16 resc_width;
  u16 resc_height;
  u32 resc_pitch;
  u32 resc_chromakey;
  u32 resc_buffer_mode;
  s32 resc_num_buffers;
  s32 resc_reg_count;

  float resc_horizontal_aspect;
  float resc_vertical_aspect;
  float resc_flex_ratio;

  GcmContextData *context;
  GcmSurface *gcm_surface;
  void *resc_host_addr;

  videoState video_state;
  videoConfiguration video_config;
  videoDeviceInfo video_device_info;
  videoResolution video_resolution;

  fragmentShaderBuffer resc_frag_shader_buffer;
  vertexArrayBuffer resc_vert_array_buffer;

  rescBuffer  resc_buffer;

  pixelBuffer resc_pixel_buffer;
  GcmSurface  resc_pixel_surface;

  rescInitConfig resc_init_config;
  u8 padding[60];

  colorBuffer resc_color_buffer;

  interlaceTable resc_interlace_table;
} rescData;

/* initialize resc */
void rescutilInitialization(void *rescdata);
s32 rescutilInitGcm(void *rescdata);
s32 rescutilInitVideo(void *rescdata);
s32 rescutilInitDsts();
s32 rescutilInitSrc(void *gcmsurface);
s32 rescutilInitBuffers(void *rescdata);
s32 rescutilAdjustAspectRatio(void *rescdata);
s32 rescutilCreateInterlaceTable(void *rescdata);

s32 rescutilMakeTiledBuffer(u8 id, rescBuffer *resc_buffer);
void* rescutilMemalign(u32 alignment, u32 size);
s32 rescutilAddressToOffset(void *resc_ptr, u32 *resc_off);
s32 rescutilTileMemory(u8 index, u32 offset, u32 size, u32 pitch, u16 base, u32 bank);
void rescutilClearBuffer(void *rescbuffer);

/* surface functions */
void rescutilInitSurface(void *gcmcontext, void *gcmsurface, void *rescbuffer );
void rescutilSetSurface(void *gcmcontext, void *gcmsurface);
void rescutilClearSurface(void *gcmcontext, u32 color );

/* Sets the target buffer to render to */
void rescutilSetRenderTarget(void *gcmcontext, void *gcmsurface);

/* draw resc buffer into gcm buffer */
void rescutilBlend(void *gcmcontext);
void rescutilBufferDraw(void *gcmcontext, void *rescbuffer, void *pixelbuffer);
void rescutilBufferDrawScale(void *gcmcontext, void *rescbuffer, void *pixelbuffer);

/* Block the PPU thread untill the previous flip operation has finished. */
void rescutilWaitFlip();

/* Flip a buffer onto the screen. Returns TRUE on success */
s32 rescutilFlip (void *gcmcontext, void *rescdata);
void rescutilFlipCallback(u32 head);

void rescutilWaitIdle(void *gcmcontext);

void rescutilFree(u32 *resc_ptr);

/* finish resc */
void rescutilFinish(void *rescdata);


#endif /* __RESCUTIL_RESC_H__ */

